% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{ranef.lcc}
\alias{ranef.lcc}
\title{Extract Model Random Effects}
\usage{
\method{ranef}{lcc}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{optional arguments passed to the \code{ranef.lme}
function.}
}
\description{
Extract the estimated random effects at level i. A data
  frame with rows given by the different groups at that level and
  columns given by the random effects.
}
\details{
See methods for \code{\link{nlme}} objects to get more
  details.
}
\examples{
\dontrun{
fm1<-lcc(dataset = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
ranef(fm1)
}
}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{coef.lcc}},
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@usp.br}
}
