% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f-capture.R
\name{f_capture}
\alias{f_capture}
\alias{dots_capture}
\title{Make a promise explicit by converting into a formula.}
\usage{
f_capture(x)

dots_capture(..., .ignore_empty = TRUE)
}
\arguments{
\item{x, ...}{An unevaluated promises}

\item{.ignore_empty}{If \code{TRUE}, empty arguments will be silently
dropped.}
}
\value{
\code{f_capture} returns a formula; \code{dots_capture}
  returns a list of formulas.
}
\description{
This should be used sparingly if you want to implement true non-standard
evaluation with 100\% magic. I recommend avoiding this unless you have
strong reasons otherwise since requiring arguments to be formulas only
adds one extra character to the inputs, and otherwise makes life much much
simpler.
}
\examples{
f_capture(a + b)
dots_capture(a + b, c + d, e + f)

# These functions will follow a chain of promises back to the
# original definition
f <- function(x) g(x)
g <- function(y) h(y)
h <- function(z) f_capture(z)
f(a + b + c)
}
