% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evir_repot.R
\name{pot_refit}
\alias{pot_refit}
\title{Fits a Poisson point process to the data, an approach sometimes known as
peaks over thresholds (POT), and returns an object of class "potd".}
\usage{
pot_refit(data, threshold = NA, nextremes = NA, run = NA,
  picture = TRUE, ...)
}
\arguments{
\item{data}{numeric vector of data, which may have a times attribute
containing (in an object of class \code{"POSIXct"}, or an object that can
be converted to that class; see \code{\link{as.POSIXct}}) the times/dates
of each observation. If no times attribute exists, the data are assumed to
be equally spaced.}

\item{threshold}{a threshold value (either this or \code{nextremes} must be
given but not both).}

\item{nextremes}{the number of upper extremes to be used (either this or
\code{threshold} must be given but not both).}

\item{run}{if the data are to be declustered the run length parameter for
the runs method (see \code{\link[evir]{decluster}}) should be entered
here.}

\item{picture}{whether or not a picture should be drawn if declustering is
performed.}

\item{...}{arguments passed to \code{\link[stats]{optim}}.}
}
\description{
This is a slightly modified versions of the \code{\link[evir]{pot}}
function in the \code{evir} package.
The main modification is to add to the returned object the argument
\code{data} supplied by the user.  This is added to the returned
(list) object with the name \code{input_data}.
}
\examples{
# We need the evir package
got_evir <- requireNamespace("evir", quietly = TRUE)
if (got_evir) {
  library(evir)
  data(danish)
  out <- pot(danish, 10)
  ls(out)
  out <- pot_refit(danish, 10)
  ls(out)
}
}
\references{
Bernhard Pfaff and Alexander McNeil (2018). evir: Extreme
  Values in R. R package version 1.7-4.
  \url{https://CRAN.R-project.org/package=evir}.
}
