% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdrop.R
\name{sdrop}
\alias{sdrop}
\title{Safely Drop Specified Columns of a Labeled Data Frame}
\usage{
sdrop(data, ...)
}
\arguments{
\item{data}{the data.frame from which columns will be removed.}

\item{...}{comma-separated, unquoted column/variable names to be discarded
(e.g., cyl, mpg, not c("cyl", "mpg")), with no other special characters or
symbols, such as quotes, parentheses, colons, minus signs, exclamation
points, or other operators.}
}
\value{
a labelr label attribute-preserving data.frame consisting of the
remaining (i.e., non-specified, non-discarded) subset of columns of the
supplied data.frame.
}
\description{
\code{sdrop} allows one to remove columns from a data.frame, returning the
remaining columns as a data.frame that preserves the labelr attributes
attached to the inputted data.frame.
}
\details{
This function accepts a data.frame, followed by a set of comma-separated,
non-quoted column names to be discarded and returns the remaining columns as
a data.frame that preserves labelr attribute information. NOTE: This command
does NOT allow for positive specification of columns to be retained; rather,
all variables not specified will be retained by default. Further, \code{sdrop}
does not supported quoted column names, dplyr-like helper functions or
other special selection syntax or idioms. See also \code{ssubset}, \code{sselect}, or
\code{sbrac}); see also \code{sfilter}, \code{ssort}, \code{srename}, \code{slab}, and \code{flab}.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

head(df, 3)
check_labs_att(df, "val.labs.raceth") # "raceth" lab specifically TRUE

dfless <- sdrop(df, id, raceth) # select only the vars id and raceth
head(dfless, 3) # selection worked
check_labs_att(dfless, "val.labs.raceth") # "raceth" value labels preserved
}
