% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdiff.R
\name{gdiff}
\alias{gdiff}
\title{Generalized lagged differences}
\usage{
gdiff(x, lag = 1L, differences = 1L, FUN = `-`, ...)
}
\arguments{
\item{x}{a numeric vector or matrix containing the values to be
    differenced.}

\item{lag}{an integer indicating which lag to use.}

\item{differences}{an integer indicating the order of the difference.}

\item{FUN}{A distance function that accepts two parameters}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
If x is a vector of length \code{n} and \code{differences = 1}, then
  the computed result is equal to the successive differences
  \code{FUN(x[(1+lag):n], x[1:(n-lag)])}.

  If \code{difference} is larger than one this algorithm is applied
  recursively to \code{x}. Note that the returned value is a vector which is
  shorter than \code{x}.

  If \code{x} is a matrix then the difference operations are carried out on each
  column separately.
}
\description{
Returns suitably lagged and iterated differences using arbitrary difference
functions.
}
\examples{
gdiff(1:4)
gdiff(1:4, FUN = `/`)
}
\seealso{
\link[base]{diff}
}

