% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{key_get}
\alias{key_get}
\alias{key_get_raw}
\alias{key_set}
\alias{key_set_with_value}
\alias{key_set_with_raw_value}
\alias{key_delete}
\alias{key_list}
\title{Query, set, delete list keys in a keyring}
\usage{
key_get(service, username = NULL, keyring = NULL)

key_get_raw(service, username = NULL, keyring = NULL)

key_set(service, username = NULL, keyring = NULL)

key_set_with_value(service, username = NULL, password = NULL,
  keyring = NULL)

key_set_with_raw_value(service, username = NULL, password = NULL,
  keyring = NULL)

key_delete(service, username = NULL, keyring = NULL)

key_list(service = NULL, keyring = NULL)
}
\arguments{
\item{service}{Service name, a character scalar.}

\item{username}{Username, a character scalar, or \code{NULL} if the key
is not associated with a username.}

\item{keyring}{For systems that support multiple keyrings, specify
the name of the keyring to use here. If \code{NULL}, then the default
keyring is used. See also \code{\link[=has_keyring_support]{has_keyring_support()}}.}

\item{password}{The secret to store. For \code{key_set}, it is read from
the console, interactively. \code{key_set_with_value} can be also used
in non-interactive mode.}
}
\value{
\code{key_get} returns a character scalar, the password or other
confidential information that was stored in the key.

\code{key_list} returns a list of keys, i.e. service names and usernames,
in a data frame.
}
\description{
These functions manipulate keys in a keyring. You can think of a keyring
as a secure key-value store.
}
\details{
\code{key_get} queries a key from the keyring.

\code{key_get_raw} queries a key and returns it as a raw vector.
Most credential stores allow storing a byte sequence with embedded null
bytes, and these cannot be represented as traditional null bytes
terminated strings. If you don't know whether the key contains an
embedded null, it is best to query it with \code{key_get_raw} instead of
\code{key_get}.

\code{key_set} sets a key in the keyring. The contents of the key is read
interactively from the terminal.

\code{key_set_with_value} is the non-interactive pair of \code{key_set}, to set
a key in the keyring.

\code{key_set_raw_with_value} sets a key to a byte sequence from a raw
vector.

\code{key_delete} deletes a key.

\code{key_list} lists all keys of a keyring, or the keys for a certain
service (if \code{service} is not \code{NULL}).
}
\examples{
# These examples use the default keyring, and they are interactive,
# so, we don't run them by default
\dontrun{
key_set("R-keyring-test-service", "donaldduck")
key_get("R-keyring-test-service", "donaldduck")
if (has_keyring_support()) key_list(service = "R-keyring-test-service")
key_delete("R-keyring-test-service", "donaldduck")

## This is non-interactive, assuming that that default keyring
## is unlocked
key_set_with_value("R-keyring-test-service", "donaldduck",
                   password = "secret")
key_get("R-keyring-test-service", "donaldduck")
if (has_keyring_support()) key_list(service = "R-keyring-test-service")
key_delete("R-keyring-test-service", "donaldduck")
}
}
