% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keypress.R
\name{keypress}
\alias{keypress}
\title{Read a single keypress at the terminal}
\usage{
keypress(block = TRUE)
}
\arguments{
\item{block}{Whether to wait for a key press, if there is none
available now.}
}
\value{
The key pressed, a character scalar. For non-blocking reads
  NA is returned if no keys are available.
}
\description{
It currently only works at Linux/Unix and OSX terminals,
and at the Windows command line. see \code{\link{has_keypress_support}}.
}
\details{
The following special keys are supported:
\itemize{
  \item Arrow keys: \sQuote{up}, \sQuote{down}, \sQuote{right},
    \sQuote{left}.
  \item Function keys: from \sQuote{f1} to \sQuote{f12}.
  \item Others: sQuote{home}, \sQuote{end},
    \sQuote{insert}, \sQuote{delete}, \sQuote{pageup},
    \sQuote{pagedown}, \sQuote{tab}, \sQuote{enter},
    \sQuote{backspace} (same as \sQuote{delete} on OSX keyboards),
    \sQuote{escape}.
  \item Control with one of the following keys: \sQuote{a}, \sQuote{b},
    \sQuote{c}, \sQuote{d}, \sQuote{e}, \sQuote{f}, \sQuote{h},
    \sQuote{k}, \sQuote{l}, \sQuote{n}, \sQuote{p}, \sQuote{t},
    \sQuote{u}, \sQuote{w}.
}
}
\examples{
\dontrun{
x <- keypress()
cat("You pressed key", x, "\\n")
}
}
\seealso{
Other keypress: \code{\link{has_keypress_support}}
}
