% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_truncated_normal}
\alias{k_truncated_normal}
\title{Returns a tensor with truncated random normal distribution of values.}
\usage{
k_truncated_normal(shape, mean = 0, stddev = 1, dtype = NULL,
  seed = NULL)
}
\arguments{
\item{shape}{A list of integers, the shape of tensor to create.}

\item{mean}{Mean of the values.}

\item{stddev}{Standard deviation of the values.}

\item{dtype}{String, dtype of returned tensor.}

\item{seed}{Integer, random seed.}
}
\value{
A tensor.
}
\description{
The generated values follow a normal distribution
with specified mean and standard deviation,
except that values whose magnitude is more than
two standard deviations from the mean are dropped and re-picked.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

