% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dprhkdecop.R
\name{dkdecop}
\alias{dkdecop}
\alias{pkdecop}
\alias{rkdecop}
\alias{pkdecop}
\alias{rkdecop}
\title{Working with \code{kdecopula} objects}
\usage{
dkdecop(u, obj, stable = FALSE)

pkdecop(u, obj)

rkdecop(n, obj, quasi = FALSE)
}
\arguments{
\item{u}{\code{mx2} matrix of evaluation points.}

\item{obj}{\code{kdecopula} object.}

\item{stable}{logical; option for stabilizing the estimator: the estimated
density is cut off at \eqn{50}.}

\item{n}{integer; number of observations.}

\item{quasi}{logical; the default (\code{FALSE}) returns pseudo-random
numbers, use \code{TRUE} for quasi-random numbers (generalized Halton, see
\code{\link[qrng:ghalton]{qrng::ghalton()}}).}
}
\value{
A numeric vector of the density/cdf or a \code{n x 2} matrix of
simulated data.
}
\description{
The function \code{\link[=kdecop]{kdecop()}} stores it's result in object of class \code{kdecopula}.
The density estimate can be evaluated on arbitrary points with \code{\link[=dkdecop]{dkdecop()}};
the cdf with \code{\link[=pkdecop]{pkdecop()}}. Furthermore, synthetic data can be simulated with
\code{\link[=rkdecop]{rkdecop()}}.
}
\examples{

## load data and transform with empirical cdf
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))

## estimation of copula density of variables 5 and 6
fit <- kdecop(udat[, 5:6])
plot(fit) 

## evaluate density estimate at (u1,u2)=(0.123,0.321)
dkdecop(c(0.123, 0.321), fit) 

## evaluate cdf estimate at (u1,u2)=(0.123,0.321)
pkdecop(c(0.123, 0.321), fit) 

## simulate 500 samples from density estimate
plot(rkdecop(500, fit))

}
\references{
#' Nagler, T. (2018)
kdecopula: An R Package for the Kernel Estimation of Bivariate Copula
Densities.
Journal of Statistical Software 84(7), 1-22
\cr \cr#'
Geenens, G., Charpentier, A., and Paindaveine, D. (2017). Probit
transformation for nonparametric kernel estimation of the copula density.
Bernoulli, 23(3), 1848-1873.
\cr \cr
Nagler, T. (2014). Kernel Methods for
Vine Copula Estimation. Master's Thesis, Technische Universitaet Muenchen,
\url{https://mediatum.ub.tum.de/node?id=1231221}
\cr \cr
Cambou, T., Hofert,
M., Lemieux, C. (2015). A primer on quasi-random numbers for copula models,
arXiv:1508.03483
}
\seealso{
\code{\link[kdecopula:kdecop]{kdecop}},
\code{\link[kdecopula:plot.kdecopula]{plot.kdecopula}},
\code{\link[qrng:ghalton]{ghalton}}
}
\author{
Thomas Nagler
}
