% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_y_vars_to_keep}
\alias{check_y_vars_to_keep}
\title{Check variables in y that will be kept in returning table}
\usage{
check_y_vars_to_keep(y_vars_to_keep, y, by)
}
\arguments{
\item{y_vars_to_keep}{either TRUE, if keep all vars in \code{y};
FALSE or NULL, if keep no vars; or character vector specifying which variables in \code{y} to keep}

\item{y}{data frame}

\item{by}{A vector of shared column names in \code{x} and \code{y} to merge on.
This defaults to the shared key columns between the two tables.
If \code{y} has no key columns, this defaults to the key of \code{x}.}
}
\value{
character vector with variable names from \code{y} table
}
\description{
check and return variable names in y to keep in returning table, excluding those that are keys of the merge
}
\examples{
\dontrun{
y1 = data.table(id = 1:2,
               y  = c(11L, 15L))
# With y_vars_to_keep TRUE
joyn:::check_y_vars_to_keep(TRUE, y1, by = "id")
# With y_vars_to_keep FALSE
joyn:::check_y_vars_to_keep(FALSE, y1, by = "id")
# Specifying which y vars to keep
joyn:::check_y_vars_to_keep("y", y1, by = "id")
}
}
\keyword{internal}
