% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_to_names.R
\name{find_header}
\alias{find_header}
\title{Find the header row in a data.frame}
\usage{
find_header(dat, ...)
}
\arguments{
\item{dat}{The input data.frame}

\item{...}{See details}
}
\value{
The row number for the header row
}
\description{
Find the header row in a data.frame
}
\details{
If \code{...} is missing, then the first row with no missing values is used.

When searching for a specified value or value within a column, the first row
with a match will be returned, regardless of the completeness of the rest of
that row.  If \code{...} has a single character argument, then the first
column is searched for that value.  If \code{...} has a named numeric
argument, then the column whose position number matches the value of that
argument is searched for the name (see the last example below).  If more than one
row is found matching a value that is searched for, the number of the first
matching row will be returned (with a warning).
}
\examples{
# the first row
find_header(data.frame(A="B"))
# the second row
find_header(data.frame(A=c(NA, "B")))
# the second row since the first has an empty value
find_header(data.frame(A=c(NA, "B"), B=c("C", "D")))
# The third row because the second column was searched for the text "E"
find_header(data.frame(A=c(NA, "B", "C", "D"), B=c("C", "D", "E", "F")), "E"=2)
}
\seealso{
Other Set names: 
\code{\link{clean_names}()},
\code{\link{mu_to_u}},
\code{\link{row_to_names}()}
}
\concept{Set names}
