% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listing.R
\name{node_list}
\alias{node_list}
\alias{node_show}
\alias{node_select}
\alias{prop_select}
\title{Lists all the nodes in an isatab object}
\usage{
node_list(x)

node_show(x, node_id)

node_select(x, node_id, inverse = FALSE)

prop_select(x, prop_id, inverse = FALSE)
}
\arguments{
\item{x}{object of class isatab}

\item{node_id}{ID of a node to show}

\item{inverse}{if TRUE, inverses the selection}

\item{prop_id}{property IDs to be selected}
}
\value{
Functions \code{node_list} and \code{node_show} return a data.frame like
object. Functions \code{node_select} and \code{prop_select} return an object of
class isatab.
}
\description{
Lists all the nodes in an isatab object
}
\details{
\code{node_list} returns a data frame with one row per node, showing the
number of properties associated with a given node and a summary of
values for that node.

\code{node_show} returns a data frame for a given \code{node_id} listing all
properties associated with that node and a summary of values for each of
the properties.

\code{node_select} returns a new object of class isatab containing only the
selected nodes.

\code{prop_select} returns a new object of class isatab containing only the
selected property IDs (which may not be node IDs!).
}
\examples{
file <- system.file('extdata', 's_isatab.txt', package='isaeditor')
isa_s <- read_isa(file)
node_list(isa_s)
}
