% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{group_by}
\alias{group_by}
\alias{group_by.ir}
\alias{ungroup.ir}
\title{Group rows in \code{ir} objects by one or more variables}
\source{
\code{\link[dplyr:group_by]{dplyr::group_by()}}
}
\usage{
group_by.ir(
  .data,
  ...,
  .add = FALSE,
  .drop = dplyr::group_by_drop_default(.data)
)

ungroup.ir(.data, ...)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{In \code{group_by()}, variables or computations to group by.
Computations are always done on the ungrouped data frame.
To perform computations on the grouped data, you need to use
a separate \code{mutate()} step before the \code{group_by()}.
Computations are not allowed in \code{nest_by()}.
In \code{ungroup()}, variables to remove from the grouping.}

\item{.add}{When \code{FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{.add = TRUE}.

This argument was previously called \code{add}, but that prevented
creating a new grouping variable called \code{add}, and conflicts with
our naming conventions.}

\item{.drop}{Drop groups formed by factor levels that don't appear in the
data? The default is \code{TRUE} except when \code{.data} has been previously
grouped with \code{.drop = FALSE}. See \code{\link[dplyr:group_by_drop_default]{group_by_drop_default()}} for details.}
}
\value{
\code{.data} with grouped rows (\code{group_by.ir()}) or ungrouped rows
(\code{ungroup.ir()}).
}
\description{
Group rows in \code{ir} objects by one or more variables
}
\examples{
## group_by
dplyr::group_by(ir_sample_data, sample_type)


## ungroup
dplyr::ungroup(dplyr::group_by(ir_sample_data, sample_type))


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{distinct.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
