% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os.manage.R
\name{os.hibernate}
\alias{os.hibernate}
\title{Hibernate the operating system (Windows) through a shell command}
\usage{
os.hibernate(s = 0, m = 0, h = 0, first_turn_hibernate_on = TRUE)
}
\arguments{
\item{s}{time to wait before shutting down (in seconds), added to m and h; passed to \code{\link[base]{Sys.sleep}}}

\item{m}{time to wait before shutting down (in minutes), added to s and h; passed to \code{\link[base]{Sys.sleep}}}

\item{h}{time to wait before shutting down (in hours), added to s and m; passed to \code{\link[base]{Sys.sleep}}}

\item{first_turn_hibernate_on}{default is TRUE. This runs "powercfg -hibernate on" in order to turn hibernate on, in cases where it was off.}
}
\value{
The status code of \code{\link[base]{shell}}.
}
\description{
This Hibernates Windows after set amount of time.
}
\examples{
\dontrun{
## when your code is extremely time-consuming, 
# you may need this function to run at the 
# end of the simulation.
os.hibernate()
}
}
\author{
Tal Galili
}
\references{
\url{http://superuser.com/questions/42124/how-can-i-put-the-computer-to-sleep-from-command-prompt-run-menu} , \url{http://www.howtogeek.com/howto/windows-vista/quick-tip-create-shutdown-restart-lock-icons-in-windows-vista/}
}
\seealso{
\code{\link[base]{system}},\code{\link[base]{shell}}, \code{\link[base]{Sys.sleep}}, 
\code{\link{is.windows}}, \code{\link{os.shutdown}}, \code{\link{os.sleep}}, \code{\link{os.hibernate}}, \code{\link{os.lock}}, \code{\link{os.restart}}
}

