% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_formula.R
\name{find_formula}
\alias{find_formula}
\title{Find model formula}
\usage{
find_formula(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A list of formulas that describe the model. For simple models,
   only one list-element, \code{conditional}, is returned. For more complex
   models, the returned list may have following elements:
   \itemize{
     \item \code{conditional}, the "fixed effects" part from the model
     \item \code{random}, the "random effects" part from the model (or the \code{id} for gee-models and similar)
     \item \code{zero_inflated}, the "fixed effects" part from the zero-inflation component of the model
     \item \code{zero_inflated_random}, the "random effects" part from the zero-inflation component of the model
     \item \code{dispersion}, the dispersion formula
     \item \code{instruments}, for fixed-effects regressions like \code{ivreg}, \code{felm} or \code{plm}, the instrumental variables
     \item \code{cluster}, for fixed-effects regressions like \code{felm}, the cluster specification
     \item \code{correlation}, for models with correlation-component like \code{gls}, the formula that describes the correlation structure
     \item \code{slopes}, for fixed-effects individual-slope models like \code{feis}, the formula for the slope parameters
   }
}
\description{
Returns the formula(s) for the different parts of a model
   (like fixed or random effects, zero-inflated component, ...).
}
\note{
For models of class \code{lme} or \code{gls} the correlation-component
  is only returned, when it is explicitly defined as named argument
  (\code{form}), e.g. \code{corAR1(form = ~1 | Mare)}
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_formula(m)
}
