% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weights.R
\name{get_weights}
\alias{get_weights}
\title{Get the values from model weights}
\usage{
get_weights(x)
}
\arguments{
\item{x}{A fitted model.}
}
\value{
The weighting variable, or \code{NULL} if no weights were specified.
}
\description{
Returns weighting variable of a model.
}
\examples{
data(mtcars)
mtcars$weight <- rnorm(nrow(mtcars), 1, .3)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars, weights = weight)
get_weights(m)

}
