% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterpretingMethod.R
\name{InterpretingMethod}
\alias{InterpretingMethod}
\title{Super class for interpreting methods}
\description{
This is a super class for all interpreting methods in the
\code{innsight} package. Implemented are the following methods:
\itemize{
\item \emph{Deep Learning Important Features} (\code{\link{DeepLift}})
\item \emph{Deep Shapley additive explanations} (\code{\link{DeepSHAP}})
\item \emph{Layer-wise Relevance Propagation} (\code{\link{LRP}})
\item Gradient-based methods:
\itemize{
\item \emph{Vanilla gradients} including \emph{Gradient\eqn{\times}Input} (\code{\link{Gradient}})
\item Smoothed gradients including \emph{SmoothGrad\eqn{\times}Input} (\code{\link{SmoothGrad}})
\item \emph{Integrated gradients} (\code{\link{IntegratedGradient}})
\item \emph{Expected gradients} (\code{\link{ExpectedGradient}})
}
\item \emph{Connection Weights} (global and local) (\code{\link{ConnectionWeights}})
\item Also some model-agnostic approaches:
\itemize{
\item \emph{Local interpretable model-agnostic explanations} (\code{\link{LIME}})
\item \emph{Shapley values} (\code{\link{SHAP}})
}
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{(\code{list})\cr
The passed data as a \code{list} of \code{torch_tensors} in the selected
data format (field \code{dtype}) matching the corresponding shapes of the
individual input layers. Besides, the channel axis is moved to the
second position after the batch size because internally only the
format \emph{channels first} is used.\cr}

\item{\code{converter}}{(\code{\link{Converter}})\cr
An instance of the \code{Converter} class that includes the
torch-converted model and some other model-specific attributes. See
\code{\link{Converter}} for details.\cr}

\item{\code{channels_first}}{(\code{logical(1)})\cr
The channel position of the given data. If \code{TRUE}, the
channel axis is placed at the second position between the batch size and
the rest of the input axes, e.g., \code{c(10,3,32,32)} for a batch of ten images
with three channels and a height and width of 32 pixels. Otherwise (\code{FALSE}),
the channel axis is at the last position, i.e., \code{c(10,32,32,3)}. This is
especially important for layers like flatten, where the order is crucial
and therefore the channels have to be moved from the internal
format "channels first" back to the original format before the layer
is calculated.\cr}

\item{\code{dtype}}{(\code{character(1)})\cr
The data type for the calculations. Either \code{'float'} for
\link{torch_float} or \code{'double'} for \link{torch_double}.\cr}

\item{\code{ignore_last_act}}{(\code{logical(1)})\cr
A logical value to include the last activation
functions into all the calculations, or not.\cr}

\item{\code{result}}{(\code{list})\cr
The results of the method on the passed data. A unified
list structure is used regardless of the complexity of the model: The outer
list contains the individual output layers and the inner list the input
layers. The results for the respective output and input layer are then
stored there as torch tensors in the given data format (field \code{dtype}).
In addition, the channel axis is moved to its original place and the last
axis contains the selected output nodes for the individual output layers
(see \code{output_idx}).\cr
For example, the structure of the result for two output
layers (output node 1 for the first and 2 and 4 for the second) and two
input layers with \code{channels_first = FALSE} looks like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{List of 2 # both output layers
  $ :List of 2 # both input layers
    ..$ : torch_tensor [batch_size, dim_in_1, channel_axis, 1]
    ..$ : torch_tensor [batch_size, dim_in_2, channel_axis, 1]
 $ :List of 2 # both input layers
    ..$ : torch_tensor [batch_size, dim_in_1, channel_axis, 2]
    ..$ : torch_tensor [batch_size, dim_in_2, channel_axis, 2]
}\if{html}{\out{</div>}}}

\item{\code{output_idx}}{(\code{list})\cr
This list of indices specifies the output nodes to which
the method is to be applied. In the order of the output layers, the list
contains the respective output nodes indices and unwanted output layers
have the entry \code{NULL} instead of a vector of indices,
e.g., \code{list(NULL, c(1,3))} for the first and third output node in the
second output layer.\cr}

\item{\code{output_label}}{(\code{list})\cr
This list of \code{factors} specifies the output nodes to which
the method is to be applied. In the order of the output layers, the list
contains the respective output nodes labels and unwanted output layers
have the entry \code{NULL} instead of a vector of labels,
e.g., \code{list(NULL, c("a", "c"))} for the first and third output node in the
second output layer.\cr}

\item{\code{verbose}}{(\code{logical(1)})\cr
This logical value determines whether a progress bar is
displayed for the calculation of the method or not. The default value is
the output of the primitive R function \code{\link[=interactive]{interactive()}}.\cr}

\item{\code{winner_takes_all}}{(\code{logical(1)})\cr
This logical value is only relevant for
models with a MaxPooling layer. Since many zeros are produced during
the backward pass due to the selection of the maximum value in the
pooling kernel, another variant is implemented, which treats a
MaxPooling as an AveragePooling layer in the backward pass to overcome
the problem of too many zero relevances. With the default value \code{TRUE},
the whole upper-layer relevance is passed to the maximum value in each
pooling window. Otherwise, if \code{FALSE}, the relevance is distributed equally
among all nodes in a pooling window.\cr}

\item{\code{preds}}{(\code{list})\cr
In this field, all calculated predictions are stored as a list of
\code{torch_tensor}s. Each output layer has its own list entry and contains
the respective predicted values.\cr}

\item{\code{decomp_goal}}{(\code{list})\cr
In this field, the method-specific decomposition objectives are stored as
a list of \code{torch_tensor}s for each output layer. For example,
GradientxInput and LRP attempt to decompose the prediction into
feature-wise additive effects. DeepLift and IntegratedGradient decompose
the difference between \eqn{f(x)} and \eqn{f(x')}. On the other hand,
DeepSHAP and ExpectedGradient aim to decompose \eqn{f(x)} minus the
averaged prediction across the reference values.\cr}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InterpretingMethod-new}{\code{InterpretingMethod$new()}}
\item \href{#method-InterpretingMethod-get_result}{\code{InterpretingMethod$get_result()}}
\item \href{#method-InterpretingMethod-plot}{\code{InterpretingMethod$plot()}}
\item \href{#method-InterpretingMethod-plot_global}{\code{InterpretingMethod$plot_global()}}
\item \href{#method-InterpretingMethod-print}{\code{InterpretingMethod$print()}}
\item \href{#method-InterpretingMethod-clone}{\code{InterpretingMethod$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-new"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this super class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$new(
  converter,
  data,
  channels_first = TRUE,
  output_idx = NULL,
  output_label = NULL,
  ignore_last_act = TRUE,
  winner_takes_all = TRUE,
  verbose = interactive(),
  dtype = "float"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{converter}}{(\code{\link{Converter}})\cr
An instance of the \code{Converter} class that includes the
torch-converted model and some other model-specific attributes. See
\code{\link{Converter}} for details.\cr}

\item{\code{data}}{(\code{\link{array}}, \code{\link{data.frame}}, \code{\link{torch_tensor}} or \code{list})\cr
The data to which the method is to be applied. These must
have the same format as the input data of the passed model to the
converter object. This means either
\itemize{
\item an \code{array}, \code{data.frame}, \code{torch_tensor} or array-like format of
size \emph{(batch_size, dim_in)}, if e.g., the model has only one input layer, or
\item a \code{list} with the corresponding input data (according to the
upper point) for each of the input layers.\cr
}}

\item{\code{channels_first}}{(\code{logical(1)})\cr
The channel position of the given data (argument
\code{data}). If \code{TRUE}, the channel axis is placed at the second position
between the batch size and the rest of the input axes, e.g.,
\code{c(10,3,32,32)} for a batch of ten images with three channels and a
height and width of 32 pixels. Otherwise (\code{FALSE}), the channel axis
is at the last position, i.e., \code{c(10,32,32,3)}. If the data
has no channel axis, use the default value \code{TRUE}.\cr}

\item{\code{output_idx}}{(\code{integer}, \code{list} or \code{NULL})\cr
These indices specify the output nodes for which the method is to be
applied. In order to allow models with multiple output layers, there are
the following possibilities to select the indices of the output
nodes in the individual output layers:
\itemize{
\item An \code{integer} vector of indices: If the model has only one output
layer, the values correspond to the indices of the output nodes, e.g.
\code{c(1,3,4)} for the first, third and fourth output node. If there are
multiple output layers, the indices of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{integer} vectors of indices: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired indices of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead
of a vector of indices, e.g. \code{list(NULL, c(1,3))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes
in the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more
output nodes.\cr
}}

\item{\code{output_label}}{(\code{character}, \code{factor}, \code{list} or \code{NULL})\cr
These values specify the output nodes for which
the method is to be applied. Only values that were previously passed with
the argument \code{output_names} in the \code{converter} can be used. In order to
allow models with multiple
output layers, there are the following possibilities to select
the names of the output nodes in the individual output layers:
\itemize{
\item A \code{character} vector or \code{factor} of labels: If the model has only one output
layer, the values correspond to the labels of the output nodes named in the
passed \code{Converter} object, e.g.,
\code{c("a", "c", "d")} for the first, third and fourth output node if the
output names are \code{c("a", "b", "c", "d")}. If there are
multiple output layers, the names of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{charactor}/\code{factor} vectors of labels: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired labels of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead of
a vector of labels, e.g., \code{list(NULL, c("a", "c"))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes in
the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more output
nodes.\cr
}}

\item{\code{ignore_last_act}}{(\code{logical(1)})\cr
Set this logical value to include the last
activation functions for each output layer, or not (default: \code{TRUE}).
In practice, the last activation (especially for softmax activation) is
often omitted.\cr}

\item{\code{winner_takes_all}}{(\code{logical(1)})\cr
This logical argument is only relevant for
models with a MaxPooling layer. Since many zeros are produced during
the backward pass due to the selection of the maximum value in the
pooling kernel, another variant is implemented, which treats a
MaxPooling as an AveragePooling layer in the backward pass to overcome
the problem of too many zero relevances. With the default value \code{TRUE},
the whole upper-layer relevance is passed to the maximum value in each
pooling window. Otherwise, if \code{FALSE}, the relevance is distributed equally
among all nodes in a pooling window.\cr}

\item{\code{verbose}}{(\code{logical(1)})\cr
This logical argument determines whether a progress bar is
displayed for the calculation of the method or not. The default value is
the output of the primitive R function \code{\link[=interactive]{interactive()}}.\cr}

\item{\code{dtype}}{(\code{character(1)})\cr
The data type for the calculations. Use
either \code{'float'} for \link{torch_float} or \code{'double'} for
\link{torch_double}.\cr}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-get_result"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-get_result}{}}}
\subsection{Method \code{get_result()}}{
This function returns the result of this method for the given data
either as an array (\code{'array'}), a torch tensor (\code{'torch.tensor'},
or \code{'torch_tensor'}) of size \emph{(batch_size, dim_in, dim_out)} or as a
data.frame (\code{'data.frame'}). This method is also implemented as a
generic S3 function \code{\link{get_result}}. For a detailed description, we refer
to our in-depth vignette (\code{vignette("detailed_overview", package = "innsight")})
or our \href{https://bips-hb.github.io/innsight/articles/detailed_overview.html#get-results}{website}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$get_result(type = "array")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{(\code{character(1)})\cr
The data type of the result. Use one of \code{'array'},
\code{'torch.tensor'}, \code{'torch_tensor'} or \code{'data.frame'}
(default: \code{'array'}).\cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The result of this method for the given data in the chosen
type.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-plot"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-plot}{}}}
\subsection{Method \code{plot()}}{
This method visualizes the result of the selected
method and enables a visual in-depth investigation with the help
of the S4 classes \code{\link{innsight_ggplot2}} and \code{\link{innsight_plotly}}.\cr
You can use the argument \code{data_idx} to select the data points in the
given data for the plot. In addition, the individual output nodes for
the plot can be selected with the argument \code{output_idx}. The different
results for the selected data points and outputs are visualized using
the ggplot2-based S4 class \code{innsight_ggplot2}. You can also use the
\code{as_plotly} argument to generate an interactive plot with
\code{innsight_plotly} based on the plot function \link[plotly:plot_ly]{plotly::plot_ly}. For
more information and the whole bunch of possibilities,
see \code{\link{innsight_ggplot2}} and \code{\link{innsight_plotly}}.\cr
\cr
\strong{Notes:}
\enumerate{
\item For the interactive plotly-based plots, the suggested package
\code{plotly} is required.
\item The ggplot2-based plots for models with multiple input layers are
a bit more complex, therefore the suggested packages \code{'grid'},
\code{'gridExtra'} and \code{'gtable'} must be installed in your R session.
\item If the global \emph{Connection Weights} method was applied, the
unnecessary argument \code{data_idx} will be ignored.
\item The predictions, the sum of relevances, and, if available, the
decomposition target are displayed by default in a box within the plot.
Currently, these are not generated for \code{plotly} plots.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$plot(
  data_idx = 1,
  output_idx = NULL,
  output_label = NULL,
  aggr_channels = "sum",
  as_plotly = FALSE,
  same_scale = FALSE,
  show_preds = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_idx}}{(\code{integer})\cr
An integer vector containing the numbers of the data
points whose result is to be plotted, e.g., \code{c(1,3)} for the first
and third data point in the given data. Default: \code{1}. This argument
will be ignored for the global \emph{Connection Weights} method.\cr}

\item{\code{output_idx}}{(\code{integer}, \code{list} or \code{NULL})\cr
The indices of the output nodes for which the results
is to be plotted. This can be either a \code{integer} vector of indices or a
\code{list} of \code{integer} vectors of indices but must be a subset of the indices for
which the results were calculated, i.e., a subset of \code{output_idx} from the
initialization \code{new()} (see argument \code{output_idx} in method \code{new()} of
this R6 class for details). By default (\code{NULL}), the smallest index
of all calculated output nodes and output layers is used.\cr}

\item{\code{output_label}}{(\code{character}, \code{factor}, \code{list} or \code{NULL})\cr
These values specify the output nodes for which
the method is to be applied. Only values that were previously passed with
the argument \code{output_names} in the \code{converter} can be used. In order to
allow models with multiple
output layers, there are the following possibilities to select
the names of the output nodes in the individual output layers:
\itemize{
\item A \code{character} vector or \code{factor} of labels: If the model has only one output
layer, the values correspond to the labels of the output nodes named in the
passed \code{Converter} object, e.g.,
\code{c("a", "c", "d")} for the first, third and fourth output node if the
output names are \code{c("a", "b", "c", "d")}. If there are
multiple output layers, the names of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{charactor}/\code{factor} vectors of labels: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired labels of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead of
a vector of labels, e.g., \code{list(NULL, c("a", "c"))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes in
the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more output
nodes.\cr
}}

\item{\code{aggr_channels}}{(\code{character(1)} or \code{\link{function}})\cr
Pass one of \code{'norm'}, \code{'sum'}, \code{'mean'} or a
custom function to aggregate the channels, e.g., the maximum
(\link[base:Extremes]{base::max}) or minimum (\link[base:Extremes]{base::min}) over the channels or only
individual channels with \code{function(x) x[1]}. By default (\code{'sum'}),
the sum of all channels is used.\cr
\emph{Note:} This argument is used only for 2D and 3D input data.\cr}

\item{\code{as_plotly}}{(\code{logical(1)})\cr
This logical value (default: \code{FALSE}) can be used to
create an interactive plot based on the library \code{plotly}
(see \code{\link{innsight_plotly}} for details).\cr
\emph{Note:} Make sure that the suggested package \code{plotly} is installed
in your R session.\cr}

\item{\code{same_scale}}{(\code{logical})\cr
A logical value that specifies whether the individual plots have the
same fill scale across multiple input layers or whether each is
scaled individually. This argument is only used if more than one input
layer results are plotted.\cr}

\item{\code{show_preds}}{(\code{logical})\cr
This logical value indicates whether the plots display the prediction,
the sum of calculated relevances, and, if available, the targeted
decomposition value. For example, in the case of GradientxInput, the
goal is to obtain a decomposition of the predicted value, while for
DeepLift and IntegratedGradient, the goal is the difference between
the prediction and the reference value, i.e., \eqn{f(x) - f(x')}.\cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns either an \code{\link{innsight_ggplot2}} (\code{as_plotly = FALSE}) or an
\code{\link{innsight_plotly}} (\code{as_plotly = TRUE}) object with the plotted
individual results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-plot_global"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-plot_global}{}}}
\subsection{Method \code{plot_global()}}{
This method visualizes the results of the selected method summarized as
boxplots/median image and enables a visual in-depth investigation of the global
behavior with the help of the S4 classes \code{\link{innsight_ggplot2}} and
\code{\link{innsight_plotly}}.\cr
You can use the argument \code{output_idx} to select the individual output
nodes for the plot. For tabular and 1D data, boxplots are created in
which a reference value can be selected from the data using the
\code{ref_data_idx} argument. For images, only the pixel-wise median is
visualized due to the complexity. The plot is generated using the
ggplot2-based S4 class \code{innsight_ggplot2}. You can also use the
\code{as_plotly} argument to generate an interactive plot with
\code{innsight_plotly} based on the plot function \link[plotly:plot_ly]{plotly::plot_ly}. For
more information and the whole bunch of possibilities, see
\code{\link{innsight_ggplot2}} and \code{\link{innsight_plotly}}.\cr \cr
\strong{Notes:}
\enumerate{
\item This method can only be used for the local \emph{Connection Weights}
method, i.e., if \code{times_input} is \code{TRUE} and \code{data} is provided.
\item For the interactive plotly-based plots, the suggested package
\code{plotly} is required.
\item The ggplot2-based plots for models with multiple input layers are
a bit more complex, therefore the suggested packages \code{'grid'},
\code{'gridExtra'} and \code{'gtable'} must be installed in your R session.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$plot_global(
  output_idx = NULL,
  output_label = NULL,
  data_idx = "all",
  ref_data_idx = NULL,
  aggr_channels = "sum",
  preprocess_FUN = abs,
  as_plotly = FALSE,
  individual_data_idx = NULL,
  individual_max = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_idx}}{(\code{integer}, \code{list} or \code{NULL})\cr
The indices of the output nodes for which the
results is to be plotted. This can be either a \code{vector} of indices or
a \code{list} of vectors of indices but must be a subset of the indices for
which the results were calculated, i.e., a subset of \code{output_idx} from
the initialization \code{new()} (see argument \code{output_idx} in method \code{new()}
of this R6 class for details). By default (\code{NULL}), the smallest index
of all calculated output nodes and output layers is used.\cr}

\item{\code{output_label}}{(\code{character}, \code{factor}, \code{list} or \code{NULL})\cr
These values specify the output nodes for which
the method is to be applied. Only values that were previously passed with
the argument \code{output_names} in the \code{converter} can be used. In order to
allow models with multiple
output layers, there are the following possibilities to select
the names of the output nodes in the individual output layers:
\itemize{
\item A \code{character} vector or \code{factor} of labels: If the model has only one output
layer, the values correspond to the labels of the output nodes named in the
passed \code{Converter} object, e.g.,
\code{c("a", "c", "d")} for the first, third and fourth output node if the
output names are \code{c("a", "b", "c", "d")}. If there are
multiple output layers, the names of the output nodes from the first
output layer are considered.
\item A \code{list} of \code{charactor}/\code{factor} vectors of labels: If the method is to be
applied to output nodes from different layers, a list can be passed
that specifies the desired labels of the output nodes for each
output layer. Unwanted output layers have the entry \code{NULL} instead of
a vector of labels, e.g., \code{list(NULL, c("a", "c"))} for the first and
third output node in the second output layer.
\item \code{NULL} (default): The method is applied to all output nodes in
the first output layer but is limited to the first ten as the
calculations become more computationally expensive for more output
nodes.\cr
}}

\item{\code{data_idx}}{(\code{integer})\cr
By default, all available data points are used
to calculate the boxplot information. However, this parameter can be
used to select a subset of them by passing the indices. For example, with
\code{c(1:10, 25, 26)} only the first 10 data points and
the 25th and 26th are used to calculate the boxplots.\cr}

\item{\code{ref_data_idx}}{(\code{integer(1)} or \code{NULL})\cr
This integer number determines the index for the
reference data point. In addition to the boxplots, it is displayed in
red color and is used to compare an individual result with the summary
statistics provided by the boxplot. With the default value (\code{NULL}),
no individual data point is plotted. This index can be chosen with
respect to all available data, even if only a subset is selected with
argument \code{data_idx}.\cr
\emph{Note:} Because of the complexity of 2D inputs, this argument is used
only for tabular and 1D inputs and disregarded for 2D inputs.\cr}

\item{\code{aggr_channels}}{(\code{character(1)} or \code{\link{function}})\cr
Pass one of \code{'norm'}, \code{'sum'}, \code{'mean'} or a
custom function to aggregate the channels, e.g., the maximum
(\link[base:Extremes]{base::max}) or minimum (\link[base:Extremes]{base::min}) over the channels or only
individual channels with \code{function(x) x[1]}. By default (\code{'sum'}),
the sum of all channels is used.\cr
\emph{Note:} This argument is used only for 2D and 3D input data.\cr}

\item{\code{preprocess_FUN}}{(\code{function})\cr
This function is applied to the method's result
before calculating the boxplots or medians. Since positive and negative values
often cancel each other out, the absolute value (\code{abs}) is used by
default. But you can also use the raw results (\code{identity}) to see the
results' orientation, the squared data (\code{function(x) x^2}) to weight
the outliers higher or any other function.\cr}

\item{\code{as_plotly}}{(\code{logical(1)})\cr
This logical value (default: \code{FALSE}) can be used to
create an interactive plot based on the library \code{plotly}
(see \code{\link{innsight_plotly}} for details).\cr
\emph{Note:} Make sure that the suggested package \code{plotly} is installed
in your R session.\cr}

\item{\code{individual_data_idx}}{(\code{integer} or \code{NULL})\cr
Only relevant for a \code{plotly} plot with tabular
or 1D inputs! This integer vector of data indices determines
the available data points in a dropdown menu, which are drawn
individually analogous to \code{ref_data_idx} only for more data points.
With the default value \code{NULL}, the first \code{individual_max} data points
are used.\cr
\emph{Note:} If \code{ref_data_idx} is specified, this data point will be
added to those from \code{individual_data_idx} in the dropdown menu.\cr}

\item{\code{individual_max}}{(\code{integer(1)})\cr
Only relevant for a \code{plotly} plot with tabular or
1D inputs! This integer determines the maximum number of
individual data points in the dropdown menu without counting
\code{ref_data_idx}. This means that if \code{individual_data_idx} has more
than \code{individual_max} indices, only the first \code{individual_max} will
be used. A too high number can significantly increase the runtime.\cr}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns either an \code{\link{innsight_ggplot2}} (\code{as_plotly = FALSE}) or an
\code{\link{innsight_plotly}} (\code{as_plotly = TRUE}) object with the plotted
summarized results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-print"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-print}{}}}
\subsection{Method \code{print()}}{
Print a summary of the method object. This summary contains the
individual fields and in particular the results of the applied method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the method object invisibly via \code{\link[base:invisible]{base::invisible}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InterpretingMethod-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InterpretingMethod-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InterpretingMethod$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
