% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeWordCloud.R
\name{MakeWordCloud}
\alias{MakeWordCloud}
\title{Create a Word Cloud from a Frequency Table of Words}
\usage{
MakeWordCloud(
  x,
  max_words = 200L,
  size = 1,
  shape = "circle",
  ellipticity = 0.65,
  ...,
  width = 910L,
  output = NULL,
  display = FALSE
)
}
\arguments{
\item{x}{'data.frame'.
A frequency table of words that includes \code{"word"} and \code{"freq"} in each column.}

\item{max_words}{'integer' number.
Maximum number of words to include in the word cloud.}

\item{size}{'numeric' number.
Font size, where the larger size indicates a bigger word.}

\item{shape}{'character' string.
Shape of the \dQuote{cloud} to draw.
Possible shapes include a \code{"circle"}, \code{"cardioid"}, \code{"diamond"},
\code{"triangle-forward"}, \code{"triangle"}, \code{"pentagon"}, and \code{"star"}.}

\item{ellipticity}{'numeric' number.
Degree of \dQuote{flatness} of the shape to draw, a value between 0 and 1.}

\item{...}{Additional arguments to be passed to the
\code{\link[wordcloud2]{wordcloud2}} function.}

\item{width}{'integer' number.
Desired image width in pixels.}

\item{output}{'character' string.
Path to the output file, by default the word cloud is copied to a temporary file.}

\item{display}{'logical' flag.
Whether to display the saved PNG file in a graphics window.
Requires access to the \pkg{png} package.}
}
\value{
The word cloud plots in PNG format, and the path of the output file is returned.
}
\description{
Create a word cloud from a frequency table of words, and save to a PNG file.
Visualizations are created using the
\sQuote{\href{https://wordcloud2-js.timdream.org/}{wordcloud2.js}} JavaScript library.
}
\details{
The \pkg{webshot} package requires the external program \href{https://phantomjs.org/}{PhantomJS},
  which may be installed using the \code{webshot::\link[webshot]{install_phantomjs}()} command.
  To recompress the PNG file to a smaller size requires that the external program
  \href{http://optipng.sourceforge.net/}{OptiPNG} is accessible through a command window.
}
\examples{
\dontrun{
MakeWordCloud(wordcloud2::demoFreq, size = 1.5, display = TRUE)
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{hplot}
