% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gg.SpatialGridDataFrame}
\alias{gg.SpatialGridDataFrame}
\title{Geom for SpatialGridDataFrame objects}
\usage{
\method{gg}{SpatialGridDataFrame}(data, ...)
}
\arguments{
\item{data}{A SpatialGridDataFrame object.}

\item{...}{Arguments passed on to \code{\link[=gg.SpatialPixelsDataFrame]{gg.SpatialPixelsDataFrame()}}.}
}
\value{
A \code{geom_tile} value.
}
\description{
Coerces input \code{SpatialGridDataFrame} to \code{SpatialPixelsDataFrame} and calls
\code{\link[=gg.SpatialPixelsDataFrame]{gg.SpatialPixelsDataFrame()}} to plot it.
Requires the \code{ggplot2} package.
}
\examples{
\donttest{
  if (require(ggplot2, quietly = TRUE) &&
      require(ggpolypath, quietly = TRUE)) {
    # Load Gorilla data

    data("gorillas", package = "inlabru")

    # Plot Gorilla elevation covariate provided as SpatialPixelsDataFrame.
    # The same syntax applies to SpatialGridDataFrame objects.

    ggplot() +
      gg(gorillas$gcov$elevation)

    # Add Gorilla survey boundary and nest sightings

    ggplot() +
      gg(gorillas$gcov$elevation) +
      gg(gorillas$boundary) +
      gg(gorillas$nests)

    # Load pantropical dolphin data

    data("mexdolphin")

    # Plot the pantropiical survey boundary, ship transects and dolphin sightings

    ggplot() +
      gg(mexdolphin$ppoly) + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers) + # ship transects as SpatialLines
      gg(mexdolphin$points) # dolphin sightings as SpatialPoints

    # Change color

    ggplot() +
      gg(mexdolphin$ppoly, color = "green") + # survey boundary as SpatialPolygon
      gg(mexdolphin$samplers, color = "red") + # ship transects as SpatialLines
      gg(mexdolphin$points, color = "blue") # dolphin sightings as SpatialPoints


    # Visualize data annotations: line width by segment number

    names(mexdolphin$samplers) # 'seg' holds the segment number
    ggplot() +
      gg(mexdolphin$samplers, aes(color = seg))

    # Visualize data annotations: point size by dolphin group size

    names(mexdolphin$points) # 'size' holds the group size
    ggplot() +
      gg(mexdolphin$points, aes(size = size))
  }
}
}
\seealso{
Other geomes for spatial data: 
\code{\link{gg.SpatialLines}()},
\code{\link{gg.SpatialPixelsDataFrame}()},
\code{\link{gg.SpatialPixels}()},
\code{\link{gg.SpatialPoints}()},
\code{\link{gg.SpatialPolygons}()},
\code{\link{gg}()},
\code{\link{gm}()}
}
\concept{geomes for spatial data}
