% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.spatial.R
\name{stransform}
\alias{stransform}
\title{Coordinate transformation for spatial objects}
\usage{
stransform(splist, crs)
}
\arguments{
\item{splist}{list of Spatial* objects}

\item{crs}{Coordinate reference system to change to}
}
\value{
List of Spatial* objects
}
\description{
This is a wrapper for the \link{spTransform} function provided by the \code{sp} package.
Given a spatial object (or a list thereof) it will transform the coordinate system according
to the parameter \code{crs}. In addition to the usual spatial objects this function is
also capables of transforming \link[INLA]{inla.mesh} objects that are equipped with a coordinate
system.#'
}
\examples{

# Load Gorilla data
data("gorillas", package = "inlabru")

# Take the mesh and transform it to latitude/longitude
tmesh = stransform(gorillas$mesh, crs = CRS("+proj=longlat"))

# Compare original and transformed mesh

multiplot(ggplot() + gg(gorillas$mesh) + ggtitle("Original mesh"),
          ggplot() + gg(tmesh) + ggtitle("Transformed mesh"))
          
}
