% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.from.probability.R
\name{incidence.from.probability}
\alias{incidence.from.probability}
\title{Generates an incidence matrix with a given cell-filling probability}
\usage{
incidence.from.probability(R, C, P = 0, constrain = TRUE, class = "matrix")
}
\arguments{
\item{R}{integer: number of rows}

\item{C}{integer: number of columns}

\item{P}{numeric: probability that a cell contains a 1; if P = 0 a probability will be chosen randomly}

\item{constrain}{boolean: ensure that no rows or columns sum to 0 (i.e., contain all 0s) or to 1 (i.e., contain all 1s)}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", igraph").}
}
\value{
An incidence matrix of class \code{matrix} or a bipartite graph of class {\link{igraph}}.
}
\description{
\code{incidence.from.probability} generates a random incidence matrix in which each cell is filled
with a 1 with a given probability.
}
\examples{
I <- incidence.from.probability(R = 10, C = 10)
I <- incidence.from.probability(R = 10, C = 10, P = .5)
I <- incidence.from.probability(R = 10, C = 10, P = .5, class = "igraph")
}
