% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRact.R
\name{incRact}
\alias{incRact}
\title{Calculation of daily first incubation off-bout and last incubation on-bout}
\usage{
incRact(data, time_column, vector.incubation)
}
\arguments{
\item{data}{data frame containing a numeric vector of 1's and 0's (incubation scores), where "1"
means "incubating individual inside nest" and "0" means "incubating individual 
outside the nests". This vector, 
under the name of \code{incR_score} is provided by \code{\link{incRscan}} in the 
first object (\emph{incRscan_data}) of the returned list. A column named "date" is needed to refer to daily
calculations.}

\item{time_column}{(character class) name of the column containing times.}

\item{vector.incubation}{(character class) name of the vector containing 
incubation scores. \code{\link{incRscan}} produces
this vector named "incR_score".}
}
\value{
a data frame containing fist off-bout and last on-bout per day in \emph{data}.
}
\description{
Using a vector of incubation scores, 
\emph{incRact}
calculates onset of activity (first off-bout in the morning),
and end of daily activity (last on-bout in the evening) per day. A column for dates, named "date"
is needed in the data argument.
}
\examples{
#' # loading example data
data(incR_procdata)
incRact (data=incR_procdata, 
              time_column="time",
              vector.incubation="incR_score")
}
\seealso{
\code{\link{incRprep}} \code{\link{incRscan}}
}
\author{
Pablo Capilla-Lasheras
}
