% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{px.flood}
\alias{px.flood}
\title{Select a region of homogeneous colour}
\usage{
px.flood(im, x, y, z = 1, sigma = 0, high_connexity = FALSE)
}
\arguments{
\item{im}{an image}

\item{x}{X-coordinate of the starting point of the region to flood}

\item{y}{Y-coordinate of the starting point of the region to flood}

\item{z}{Z-coordinate of the starting point of the region to flood}

\item{sigma}{Tolerance concerning neighborhood values.}

\item{high_connexity}{Use 8-connexity (only for 2d images, default FALSE).}
}
\description{
Select pixels that are similar to a seed pixel. The underlying algorithm is the same as the bucket fill (AKA flood fill). Unlike with the bucket fill, the image isn't changed, the function simply returns a pixel set containing the selected pixels.
}
\details{
Old name: selectSimilar (deprecated)
}
\examples{
\dontshow{cimg.limit.openmp()}
#Select part of a sail 
px <- px.flood(boats,x=169,y=179,sigma=.2) 
plot(boats)
highlight(px)
}
\seealso{
bucketfill
}
