% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgs.R
\name{pgs}
\alias{pgs}
\title{Calculate Personal Glycemic State (PGS)}
\usage{
pgs(data, dur_length = 20, end_length = 30)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl". Should only be data for 1 subject. In case multiple subject ids are detected, a warning is produced and only 1st subject is used.}

\item{dur_length}{Numeric value specifying the minimum duration in minutes to
be considered an episode. Note dur_length should be a multiple of the data recording
interval otherwise the function will round up to the nearest multiple.
Default is 20 minutes to match the original PGS definition.}

\item{end_length}{Numeric value specifying the minimum duration in minutes of
improved glycemia for an episode to end.
Default is 30 minutes to match original PGS definition.}
}
\value{
A tibble object with two columns:
subject id and corresponding PGS value.
}
\description{
The function mad produces PGS values in a tibble object.
}
\details{
A tibble object with 1 row for each subject, a column for subject id and
a column for GVP values is returned. NA glucose values are
omitted from the calculation. Note that the duration thresholds for episodes
are NOT the same as the episode_calculation defaults. The defaults chosen for
PGS are those that match the original PGS paper definition, while the
episode_calculation defaults match the consensus.
}
\examples{

data(example_data_1_subject)
pgs(example_data_1_subject)


}
\references{
Hirsch et al. (2017): A Simple Composite Metric for the Assessment of Glycemic
Status from Continuous Glucose Monitoring Data: Implications for Clinical Practice
and the Artificial Pancreas
\emph{Diabetes Technol Ther} \strong{19(S3)} .S38-S48,
\doi{10.1089/dia.2017.0080}.
}
\seealso{
episode_calculation()
}
\author{
Elizabeth Chun
}
