% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ig.R
\name{pcondig21}
\alias{pcondig21}
\alias{qcondig21}
\alias{qcondig}
\alias{pcondig}
\alias{pcondig12}
\alias{qcondig12}
\alias{dig}
\alias{logdig}
\alias{pig}
\alias{rig}
\title{IG Copula Family Functions}
\usage{
pcondig21(v, u, theta, alpha)

qcondig21(p, u, theta, alpha)

qcondig(p, u, theta, alpha)

pcondig(v, u, theta, alpha)

pcondig12(u, v, theta, alpha)

qcondig12(p, v, theta, alpha)

dig(u, v, theta, alpha)

logdig(u, v, theta, alpha)

pig(u, v, theta, alpha)

rig(n, theta, alpha)
}
\arguments{
\item{u, v}{Vectors of values between 0 and 1 representing values of the first
and second copula variables.}

\item{theta}{Parameter of the IG copula family. Vectorized; >0.}

\item{alpha}{Parameter of the IG copula family. Vectorized; >0.}

\item{p}{Vector of quantile levels between 0 and 1
to evaluate a quantile function at.}

\item{n}{Positive integer. Number of observations to randomly draw.}
}
\value{
Numeric vector of length equal to the length of the input vector(s).
}
\description{
Functions related to the IG copula family, denoted  by \code{'ig'}.
}
\note{
Inputting two vectors greater than length 1 is allowed, if they're
the same length.
Also, \code{qcondig21} and \code{pcondig21} are the same as
\code{qcondig} and \code{pcondig} -- they're the distributions of
variable 2 given 1.
}
\examples{
u <- runif(10)
v <- runif(10)
pig(u, v, theta = 5, alpha = 1)
dig(u, v, theta = 2, alpha = 2)
logdig(u, v, theta = 2, alpha = 2)
pcondig21(v, u, theta = 3, alpha = 6)
qcondig21(v, u, theta = 3, alpha = 6)
pcondig12(u, v, theta = 3, alpha = 6)
qcondig12(u, v, theta = 3, alpha = 6)
rig(10, theta = 3, alpha = 3)

# log density available for extra precision
log(dig(0.1, 0.1, 2.5, 12.3)) == logdig(0.1, 0.1, 2.5, 12.3)
}
