% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ExtractPartsDecimal}
\alias{icd9ExtractPartsDecimal}
\title{icd9ExtractPartsDecimal}
\usage{
icd9ExtractPartsDecimal(icd9Decimal, leadingZeroes = T, minorEmpty = "",
  validate = F)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{leadingZeroes}{logical whether to fill out major part with zeroes, or
just truncate to the left. If E code, there is no valid code since
E800-E999 is defined. V codes could be V0x or Vxx, and so could be zero
padded.}

\item{minorEmpty}{vector of length one, to be used in place of
minor part of zero. Defaults to ""}

\item{validate}{logical whether to validate the input ICD-9 codes for
correctness. There may be additional simple checks, e.g. whether the code
is of the right type, regardless of this argument.}
}
\description{
icd9ExtractPartsDecimal
}
\keyword{internal}
\keyword{manip}

