% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{get_billable}
\alias{get_billable}
\alias{get_billable.icd9}
\alias{get_billable.icd9cm}
\alias{get_billable.icd10}
\alias{get_billable.icd10cm}
\alias{get_billable.default}
\title{Get the subset of codes that are billable according to ICD-9-CM or ICD-10-CM}
\usage{
get_billable(...)

\method{get_billable}{icd9}(...)

\method{get_billable}{icd9cm}(x, short_code = guess_short(x), invert = FALSE, ...)

\method{get_billable}{icd10}(x, short_code = guess_short(x), invert = FALSE, ...)

\method{get_billable}{icd10cm}(x, short_code = guess_short(x), invert = FALSE, ...)

\method{get_billable}{default}(x, short_code = guess_short(x), ...)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{input vector of ICD codes}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{invert}{Single logical value. Returns the inverse of the result. E.g.
if seeking valid ICD-9 codes, the invalid ones are returned.}
}
\description{
Using the equivalent \code{\link[=get_leaf]{get_leaf()}} is preferred.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd9cm}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd10}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd10cm}: Prefer 'leaf' to 'billable' for generality.

\item \code{default}: Prefer 'leaf' to 'billable' for generality.
}}

\seealso{
\code{\link[=is_leaf]{is_leaf()}}
}
