% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{Parametric bootstrap}
\usage{
bootstrap(object, B = 1000, extra_param = FALSE, ...)
}
\arguments{
\item{object}{an \code{object} representing a fitted model (see 'Details').}

\item{B}{an \code{integer} for number of bootstrap replicates (default
1,000).}

\item{extra_param}{if \code{TRUE}, bootstrap is also performed for extra parameters
(see 'Details').}

\item{...}{additional optional arguments to pass to \code{ibControl}.}
}
\value{
A \code{matrix} p (size of parameter) times B of bootstrapped estimates.
}
\description{
Method for generating parametric bootstrap estimates from
a fitted model.
}
\details{
This method is a simple wrapper around the \code{ib} method
where number of iterations is set to 1.
}
\examples{

## bootstrap poisson regression
counts <- c(18,17,15,20,10,20,25,13,12)
outcome <- gl(3,1,9)
treatment <- gl(3,3)
pois_fit <- glm(counts ~ outcome + treatment, family = poisson())

## make 100 paramtric bootstrap replicates
boot_dist <- bootstrap(pois_fit, B = 100)
}
\seealso{
\code{\link{ib}}, \code{\link{ibControl}}
}
\author{
Samuel Orso
}
