% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_rblood2plasma.R
\name{calc_rblood2plasma}
\alias{calc_rblood2plasma}
\title{Calculate the constant ratio of the blood concentration to the plasma
concentration.}
\usage{
calc_rblood2plasma(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  hematocrit = NULL,
  Krbc2pu = NULL,
  Funbound.plasma = NULL,
  default.to.human = FALSE,
  species = "Human",
  adjusted.Funbound.plasma = TRUE,
  suppress.messages = TRUE
)
}
\arguments{
\item{chem.cas}{Either the CAS number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Parameters from \code{\link{parameterize_schmitt}}}

\item{hematocrit}{Overwrites default hematocrit value in calculating
Rblood2plasma.}

\item{Krbc2pu}{The red blood cell to unbound plasma chemical partition
coefficient, typically from \code{\link{predict_partitioning_schmitt}}}

\item{Funbound.plasma}{The fraction of chemical unbound (free) in the
presence of plasma protein}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{adjusted.Funbound.plasma}{Whether or not to use Funbound.plasma
adjustment.}

\item{suppress.messages}{Determine whether to display certain usage
feedback.}
}
\value{
The blood to plasma chemical concentration ratio
}
\description{
This function calculates the constant ratio of the blood concentration to
the plasma concentration.
}
\details{
The red blood cell (RBC) parition coefficient as predicted by the Schmitt
(2008) method is used in the calculation. The value is calculated with the
equation: 1 - hematocrit + hematocrit * Krbc2pu * Funbound.plasma, summing
the red blood cell to plasma and plasma:plasma (equal to 1) partition
coefficients multiplied by their respective fractional volumes. When
species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data (hematocrit and temperature), but substitues
human fraction unbound and tissue volumes.
}
\examples{

calc_rblood2plasma(chem.name="Bisphenol A")
calc_rblood2plasma(chem.name="Bisphenol A",species="Rat")

}
\references{
Schmitt W. "General approach for the calculation of tissue to
plasma partition coefficients." Toxicology In Vitro, 22, 457-467 (2008).

Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of 
pharmacokinetics and pharmacodynamics 44.6 (2017): 549-565.

Ruark, Christopher D., et al. "Predicting passive and active tissue: plasma 
partition coefficients: interindividual and interspecies variability." 
Journal of pharmaceutical sciences 103.7 (2014): 2189-2198.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
