% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_loss.R
\name{average_loss}
\alias{average_loss}
\alias{average_loss.default}
\alias{average_loss.ranger}
\alias{average_loss.Learner}
\alias{average_loss.explainer}
\title{Average Loss}
\usage{
average_loss(object, ...)

\method{average_loss}{default}(
  object,
  X,
  y,
  pred_fun = stats::predict,
  BY = NULL,
  loss = "squared_error",
  w = NULL,
  ...
)

\method{average_loss}{ranger}(
  object,
  X,
  y,
  pred_fun = function(m, X, ...) stats::predict(m, X, ...)$predictions,
  BY = NULL,
  loss = "squared_error",
  w = NULL,
  ...
)

\method{average_loss}{Learner}(
  object,
  v,
  X,
  y,
  pred_fun = NULL,
  BY = NULL,
  loss = "squared_error",
  w = NULL,
  ...
)

\method{average_loss}{explainer}(
  object,
  X = object[["data"]],
  y = object[["y"]],
  pred_fun = object[["predict_function"]],
  BY = NULL,
  loss = "squared_error",
  w = object[["weights"]],
  ...
)
}
\arguments{
\item{object}{Fitted model object.}

\item{...}{Additional arguments passed to \code{pred_fun(object, X, ...)},
for instance \code{type = "response"} in a \code{\link[=glm]{glm()}} model.}

\item{X}{A data.frame or matrix serving as background dataset.}

\item{y}{Vector/matrix of the response corresponding to \code{X}.}

\item{pred_fun}{Prediction function of the form \verb{function(object, X, ...)},
providing \eqn{K \ge 1} predictions per row. Its first argument represents the
model \code{object}, its second argument a data structure like \code{X}. Additional arguments
(such as \code{type = "response"} in a GLM, or \code{reshape = TRUE} in a multiclass XGBoost
model) can be passed via \code{...}. The default, \code{\link[stats:predict]{stats::predict()}}, will work in
most cases.}

\item{BY}{Optional grouping vector.}

\item{loss}{One of "squared_error", "logloss", "mlogloss", "poisson",
"gamma", "absolute_error", "classification_error". Alternatively, a loss function
can be provided that turns observed and predicted values into a numeric vector or
matrix of unit losses of the same length as \code{X}.
For "mlogloss", the response \code{y} can either be a dummy matrix or a discrete vector.
The latter case is handled via \code{model.matrix(~ as.factor(y) + 0)}.
For "classification_error", both predictions and responses can be non-numeric.}

\item{w}{Optional vector of case weights for each row of \code{X}.}

\item{v}{Vector of feature names, by default \code{colnames(X)}.}
}
\value{
A matrix with one row per group and one column per loss dimension.
}
\description{
Calculates the average loss of a model on a given dataset,
optionally grouped by a discrete vector.
}
\section{Methods (by class)}{
\itemize{
\item \code{average_loss(default)}: Default method.

\item \code{average_loss(ranger)}: Method for "ranger" models.

\item \code{average_loss(Learner)}: Method for "mlr3" models.

\item \code{average_loss(explainer)}: Method for DALEX "explainer".

}}
\section{Losses}{


The default \code{loss} is the "squared_error". Other choices:
\itemize{
\item "absolute_error": The absolute error is the loss corresponding to median regression.
\item "poisson": Unit Poisson deviance, i.e., the loss function used in
Poisson regression. Actual values \code{y} and predictions must be non-negative.
\item "gamma": Unit gamma deviance, i.e., the loss function of Gamma regression.
Actual values \code{y} and predictions must be positive.
\item "logloss": The Log Loss is the loss function used in logistic regression,
and the top choice in probabilistic binary classification. Responses \code{y} and
predictions must be between 0 and 1. Predictions represent probabilities of
having a "1".
\item "mlogloss": Multi-Log-Loss is the natural loss function in probabilistic multi-class
situations. If there are K classes and n observations, the predictions form
a (n x K) matrix of probabilities (with row-sums 1).
The observed values \code{y} are either passed as (n x K) dummy matrix,
or as discrete vector with corresponding levels.
The latter case is turned into a dummy matrix via
\code{model.matrix(~ as.factor(y) + 0)}.
\item "classification_error": Misclassification error. Both the
observed values \code{y} and the predictions can be character/factor. This
loss function can be used in non-probabilistic classification settings.
BUT: Probabilistic classification (with "mlogloss") is clearly preferred in most
situations.
\item A function with signature \code{f(actual, predicted)}, returning a numeric
vector or matrix of the same length as the input.
}
}

\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ ., data = iris)
average_loss(fit, X = iris, y = iris$Sepal.Length)
average_loss(fit, X = iris, y = iris$Sepal.Length, BY = iris$Species)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width + Species, data = iris)
average_loss(fit, X = iris, y = iris[1:2])
average_loss(fit, X = iris, y = iris[1:2], loss = "gamma", BY = iris$Species)
}
