% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/howler.R
\name{howler}
\alias{howler}
\title{Create a Howler Audio Player}
\usage{
howler(
  tracks,
  options = list(),
  track_formats = NULL,
  auto_continue = FALSE,
  auto_loop = FALSE,
  seek_ping_rate = 1000,
  elementId = NULL
)
}
\arguments{
\item{tracks}{A named vector of file paths to sounds. If multiple file extensions are included, then use a named
list instead, with each list item containing each extension of the sound.}

\item{options}{A named list of options to add to the player. For a full list of options see
\url{https://github.com/goldfire/howler.js}}

\item{track_formats}{An optional list of formats of the sounds. By default 'howler' will guess the format to
play in. Must be the same length as tracks}

\item{auto_continue}{If there are multiple files, would you like to auto play the next file after the current
one has finished? Defaults to \code{TRUE}}

\item{auto_loop}{Once all files have been played, would you like to restart playing the playlist?
Defaults to \code{FALSE}}

\item{seek_ping_rate}{Number of milliseconds between each update of `input$\{id\}_seek` while playing. Default is
set to 1000. If set to 0, then `input$\{id\}_seek` will not exist.}

\item{elementId}{HTML id tag to be given to the howler player element}
}
\value{
A shiny.tag containing all of the required options for a \code{Howl} JS object to be initialised in a shiny application.

On the server side there will be up to four additional objects available as inputs:
\describe{
\item{\code{\{id\}_playing}}{A logical value as to whether or not the \code{howler} is playing audio}
\item{\code{\{id\}_track}}{Basename of the file currently loaded}
\item{\code{\{id\}_seek}}{(If \code{seek_ping_rate > 0}) the current time (in seconds) of the track loaded}
\item{\code{\{id\}_duration}}{The duration (in seconds) of the track loaded}
}
}
\description{
\code{howler} is used to initialise the 'howler.js' framework by adding all of the specified tracks to the
player, and can be run by either including UI buttons or server-side actions.
}
\details{
All buttons associated with the \code{howler} should be given the same \code{id} argument. This is to ensure
that the buttons are linked to the player.

i.e. If \code{howler(id = "howler")}, then \code{howlerPlayButton(id = "howler")}
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    howler(elementId = "howler", c(sound = "audio/sound.mp3")),
    howlerPlayPauseButton("howler")
  )

  server <- function(input, output) {
  }

  runShiny(ui, server)
}

\dontrun{
# Multiple file formats
howler(
  elementId = "howler",
  list(
    track_1 = c("audio/sound.webm", "audio/sound.mp3"),
    track_2 = c("audio/sound2.webm", "audio/sound2.mp3"),
  )
)
}

}
\seealso{
\code{\link{howlerButton}}, \code{\link{howlerServer}}
}
