% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.cut.R
\name{add.cut}
\alias{add.cut}
\title{Add New Cut Thresholds}
\usage{
add.cut(cuts, new.cuts, cut.id = "manual", update = FALSE)
}
\arguments{
\item{cuts}{a list of cuts generated using \code{\link{make.cut}}}

\item{new.cuts}{a list of new cut thresholds to be added to \code{cuts}}

\item{cut.id}{string identifying the new cuts}

\item{update}{if FALSE (the default) adding a \code{cut.id} that already exists in \code{cuts}
will return an error}
}
\value{
an updated \code{cuts} matrix with an extra set of thresholds named \code{cut.id}.
}
\description{
Add new manual cuts to the \code{cuts} matrix generated using \code{\link{make.cut}}
}
\details{
The matrix can be cut using either the fixed cuts (\code{type='fixed'}), or the combined cuts (\code{type='combined'})
where the limits have been adjusted to match local minima and maxima.
}
\examples{
# generate a random 3D matrix with 2 peaks
mat <- rbind(matrix(rnorm(300),ncol=3),
             matrix(rnorm(300,5,1),ncol=3))
dimnames(mat)[[2]] <- LETTERS[1:3]
# estimate the Hilbert order
hilbert.order(mat)
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
}
\author{
Yann Abraham
}
