% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{spearmans.hermite_estimator_bivar}
\alias{spearmans.hermite_estimator_bivar}
\title{Estimates the Spearman's rank correlation coefficient}
\usage{
\method{spearmans}{hermite_estimator_bivar}(this, clipped = FALSE)
}
\arguments{
\item{this}{A hermite_estimator_bivar object.}

\item{clipped}{A boolean value. Indicates whether to clip Spearman's rank 
correlation estimates to lie between -1 and 1.}
}
\value{
A numeric value.
}
\description{
This method calculates the Spearman's rank correlation coefficient value
using the hermite_estimator_bivar object (this).
}
\details{
The method utilizes the estimator defined in the paper Stephanou, Michael 
and Varughese, Melvin. "Sequential Estimation of Nonparametric Correlation 
using Hermite Series Estimators." arXiv Preprint (2020), 
https://arxiv.org/abs/2012.06287

The object must be updated with observations prior to the use of this method.
}
\examples{
hermite_est <- hermite_estimator_bivar(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, matrix(rnorm(30*2), nrow=30, 
ncol=2, byrow = TRUE))
spearmans_est <- spearmans(hermite_est)
}
