% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5Read}
\alias{h5Read}
\alias{h5Read.H5Group}
\alias{h5Read.H5File}
\alias{h5Read.character}
\title{Read data from an existing HDF5 link}
\usage{
h5Read(x, name = NULL, ...)

\method{h5Read}{H5Group}(x, name = NULL, transpose = FALSE, toS4.func = NULL, ...)

\method{h5Read}{H5File}(x, name = NULL, transpose = FALSE, toS4.func = NULL, ...)

\method{h5Read}{character}(x, name = NULL, transpose = FALSE, toS4.func = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{name}{Name of the HDF5 link to be read.}

\item{...}{Arguments passed to \code{\link{h5ReadDataset}}.}

\item{transpose}{Whether or not to transpose the read matrix. Only works for 
a 2-dimension array-like data.}

\item{toS4.func}{A function to convert the read R list into an S4 object.}
}
\value{
The load R object. Currently support \code{vector}, \code{matrix}, 
\code{data.frame}, \code{list} and sparse matrix (\code{dgCMatrix} and 
\code{dgRMatrix}).
}
\description{
Function to read data from an existing HDF5 group.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")

# Read a matrix
x <- h5Read(file, name = "X")
x <- h5Read(file, name = "X", transpose = TRUE)
x <- h5Read(file, name = "X", idx_list = list(1:10, 1:20))
x <- h5Read(
  file, 
  name = "X", 
  idx_list = list(1:10, 1:20), 
  transpose = TRUE
)

# Read a dgCMatrix
x <- h5Read(file, name = "raw/X")
x <- h5Read(file, name = "raw/X", transpose = TRUE)

# Read a data.frame
x <- h5Read(file, name = "obs")
x <- h5Read(file, name = "raw/var") # Read a data.frame with empty column

# Read a list
x <- h5Read(file)
x <- h5Read(file, "raw")
x <- h5Read(file, "obsm")

}
