% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.glm}
\alias{h2o.glm}
\title{H2O Generalized Linear Models}
\usage{
h2o.glm(x, y, training_frame, model_id, validation_frame, max_iterations = 50,
  beta_epsilon = 0, solver = c("IRLSM", "L_BFGS"), standardize = TRUE,
  family = c("gaussian", "binomial", "poisson", "gamma", "tweedie"),
  link = c("family_default", "identity", "logit", "log", "inverse",
  "tweedie"), tweedie_variance_power = NaN, tweedie_link_power = NaN,
  alpha = 0.5, prior = 0, lambda = 1e-05, lambda_search = FALSE,
  nlambdas = -1, lambda_min_ratio = -1, nfolds = 0, fold_column = NULL,
  fold_assignment = c("AUTO", "Random", "Modulo"),
  keep_cross_validation_predictions = FALSE, beta_constraints = NULL,
  offset_column = NULL, weights_column = NULL, intercept = TRUE,
  max_active_predictors = -1, ...)
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the GLM model.}

\item{y}{A character string or index that represent the response variable in the model.}

\item{training_frame}{An \code{\linkS4class{H2OFrame}} object containing the variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If none is given, an id will automatically be generated.}

\item{validation_frame}{An \code{\linkS4class{H2OFrame}} object containing the variables in the model.}

\item{max_iterations}{A non-negative integer specifying the maximum number of iterations.}

\item{beta_epsilon}{A non-negative number specifying the magnitude of the maximum difference between the coefficient estimates from successive iterations.
Defines the convergence criterion for \code{h2o.glm}.}

\item{solver}{A character string specifying the solver used: IRLSM (supports more features), L_BFGS (scales better for datasets with many columns)}

\item{standardize}{A logical value indicating whether the numeric predictors should be standardized to have a mean of 0 and a variance of 1 prior to
training the models.}

\item{family}{A character string specifying the distribution of the model:  gaussian, binomial, poisson, gamma, tweedie.}

\item{link}{A character string specifying the link function. The default is the canonical link for the \code{family}. The supported links for each of
the \code{family} specifications are:\cr
\code{"gaussian"}: \code{"identity"}, \code{"log"}, \code{"inverse"}\cr
\code{"binomial"}: \code{"logit"}, \code{"log"}\cr
\code{"poisson"}: \code{"log"}, \code{"identity"}\cr
\code{"gamma"}: \code{"inverse"}, \code{"log"}, \code{"identity"}\cr
\code{"tweedie"}: \code{"tweedie"}\cr}

\item{tweedie_variance_power}{A numeric specifying the power for the variance function when \code{family = "tweedie"}.}

\item{tweedie_link_power}{A numeric specifying the power for the link function when \code{family = "tweedie"}.}

\item{alpha}{A numeric in [0, 1] specifying the elastic-net mixing parameter.
The elastic-net penalty is defined to be:
\deqn{P(\alpha,\beta) = (1-\alpha)/2||\beta||_2^2 + \alpha||\beta||_1 = \sum_j [(1-\alpha)/2 \beta_j^2 + \alpha|\beta_j|]},
making \code{alpha = 1} the lasso penalty and \code{alpha = 0} the ridge penalty.}

\item{prior}{(Optional) A numeric specifying the prior probability of class 1 in the response when \code{family = "binomial"}.
The default prior is the observational frequency of class 1.}

\item{lambda}{A non-negative shrinkage parameter for the elastic-net, which multiplies \eqn{P(\alpha,\beta)} in the objective function.
When \code{lambda = 0}, no elastic-net penalty is applied and ordinary generalized linear models are fit.}

\item{lambda_search}{A logical value indicating whether to conduct a search over the space of lambda values starting from the lambda max, given
\code{lambda} is interpreted as lambda min.}

\item{nlambdas}{The number of lambda values to use when \code{lambda_search = TRUE}.}

\item{lambda_min_ratio}{Smallest value for lambda as a fraction of lambda.max. By default if the number of observations is greater than the
the number of variables then \code{lambda_min_ratio} = 0.0001; if the number of observations is less than the number
of variables then \code{lambda_min_ratio} = 0.01.}

\item{nfolds}{(Optional) Number of folds for cross-validation. If \code{nfolds >= 2}, then \code{validation} must remain empty.}

\item{fold_column}{(Optional) Column with cross-validation fold index assignment per observation}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified
Must be "AUTO", "Random" or "Modulo"}

\item{keep_cross_validation_predictions}{Whether to keep the predictions of the cross-validation models}

\item{beta_constraints}{A data.frame or H2OParsedData object with the columns ["names",
"lower_bounds", "upper_bounds", "beta_given"], where each row corresponds to a predictor
in the GLM. "names" contains the predictor names, "lower_bounds" and "upper_bounds" are the lower
and upper bounds of beta, and "beta_given" is some supplied starting values for beta.}

\item{offset_column}{Specify the offset column.}

\item{weights_column}{Specify the weights column.}

\item{intercept}{Logical, include constant term (intercept) in the model}

\item{max_active_predictors}{(Optional) Convergence criteria for number of predictors when using L1 penalty.}

\item{...}{(Currently Unimplemented)
coefficients.}
}
\value{
A subclass of \code{\linkS4class{H2OModel}} is returned. The specific subclass depends on the machine learning task at hand
        (if it's binomial classification, then an \code{\linkS4class{H2OBinomialModel}} is returned, if it's regression then a
         \code{\linkS4class{H2ORegressionModel}} is returned). The default print-out of the models is shown, but further GLM-specifc
         information can be queried out of the object. To access these various items, please refer to the seealso section below.

         Upon completion of the GLM, the resulting object has coefficients, normalized coefficients, residual/null deviance, aic,
         and a host of model metrics including MSE, AUC (for logistic regression), degrees of freedom, and confusion matrices. Please
         refer to the more in-depth GLM documentation available here: \url{http://h2o-release.s3.amazonaws.com/h2o-dev/rel-shannon/2/docs-website/h2o-docs/index.html#Data+Science+Algorithms-GLM},
}
\description{
Fit a generalized linear model, specified by a response variable, a set of predictors, and a description of the error distribution.
}
\examples{
localH2O = h2o.init()

# Run GLM of CAPSULE ~ AGE + RACE + PSA + DCAPS
prostatePath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.importFile(localH2O, path = prostatePath, destination_frame = "prostate.hex")
h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"), training_frame = prostate.hex,
        family = "binomial", nfolds = 0, alpha = 0.5, lambda_search = FALSE)

# Run GLM of VOL ~ CAPSULE + AGE + RACE + PSA + GLEASON
myX = setdiff(colnames(prostate.hex), c("ID", "DPROS", "DCAPS", "VOL"))
h2o.glm(y = "VOL", x = myX, training_frame = prostate.hex, family = "gaussian",
        nfolds = 0, alpha = 0.1, lambda_search = FALSE)

\donttest{
 # GLM variable importance
 # Also see:
 #   https://github.com/h2oai/h2o/blob/master/R/tests/testdir_demos/runit_demo_VI_all_algos.R
 data.hex = h2o.importFile(
   localH2O,
   path = "https://raw.github.com/h2oai/h2o/master/smalldata/bank-additional-full.csv",
   destination_frame = "data.hex")
 myX = 1:20
 myY="y"
 my.glm = h2o.glm(x=myX, y=myY, training_frame=data.hex, family="binomial", standardize=TRUE,
                 lambda_search=TRUE)
}
}
\seealso{
\code{\link{predict.H2OModel}} for prediction, \code{\link{h2o.mse}}, \code{\link{h2o.auc}},
         \code{\link{h2o.confusionMatrix}}, \code{\link{h2o.performance}}, \code{\link{h2o.giniCoef}}, \code{\link{h2o.logloss}},
         \code{\link{h2o.varimp}}, \code{\link{h2o.scoreHistory}}
}

