% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.anomaly}
\alias{h2o.anomaly}
\title{Anomaly Detection via H2O Deep Learning Model}
\usage{
h2o.anomaly(object, data)
}
\arguments{
\item{object}{An \linkS4class{H2OAutoEncoderModel} object that represents the
model to be used for anomaly detection.}

\item{data}{An \linkS4class{H2OFrame} object.}
}
\value{
Returns an \linkS4class{H2OFrame} object containing the
        reconstruction MSE.
}
\description{
Detect anomalies in an H2O dataset using an H2O deep learning model with
auto-encoding.
}
\examples{
\donttest{
library(h2o)
localH2O = h2o.init()
prosPath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.importFile(localH2O, path = prosPath)
prostate.dl = h2o.deeplearning(x = 3:9, training_frame = prostate.hex, autoencoder = TRUE,
                               hidden = c(10, 10), epochs = 5)
prostate.anon = h2o.anomaly(prostate.dl, prostate.hex)
head(prostate.anon)
}
}
\seealso{
\code{\link{h2o.deeplearning}} for making an H2OAutoEncoderModel.
}

