% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_table_lines}
\alias{opt_table_lines}
\title{Option to set table lines to different extents}
\usage{
opt_table_lines(data, extent = c("all", "none", "default"))
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{extent}{The extent to which lines will be visible in the table. Options
are \code{"all"}, \code{"none"}, or \code{"default"}.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{opt_table_lines()} function sets table lines in one of three possible
ways: (1) all possible table lines drawn (\code{"all"}), (2) no table lines at all
(\code{"none"}), and (3) resetting to the default line styles (\code{"default"}). This
is great if you want to start off with lots of lines and subtract just a few
of them with \code{\link[=tab_options]{tab_options()}} or \code{\link[=tab_style]{tab_style()}}. Or, use it to start with a
completely lineless table, adding individual lines as needed.
}
\section{Figures}{

\if{html}{\figure{man_opt_table_lines_1.png}{options: width=100\%}}
}

\section{Function ID}{

9-5
}

\examples{
# Use `exibble` to create a gt table with
# a number of table parts added; then, use
# the `opt_table_lines()` function to
# haves lines everywhere there can possibly
# be lines
tab_1 <-
  exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = vars(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = vars(currency),
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_table_lines()

}
\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_outline}()}
}
\concept{Table Option Functions}
