% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{measures}
\alias{measures}
\title{Error measures for the provided forecasts}
\usage{
measures(holdout, forecast, actual, digits = NULL, benchmark = c("naive",
  "mean"))
}
\arguments{
\item{holdout}{The vector of the holdout values.}

\item{forecast}{The vector of forecasts produced by a model.}

\item{actual}{The vector of actual in-sample values.}

\item{digits}{Number of digits of the output. If \code{NULL}
then no rounding is done.}

\item{benchmark}{The character variable, defining what to use as
benchmark for relative measures. Can be either \code{"naive"} or
\code{"mean"} (arithmetic mean of the whole series. The latter
can be useful when dealing with intermittent data.}
}
\value{
The functions returns the named vector of errors:
\itemize{
\item MAE,
\item MSE
\item MPE,
\item MAPE,
\item MASE,
\item sMAE,
\item sMSE,
\item sCE,
\item rMAE,
\item rRMSE,
\item rAME,
\item cbias,
\item sPIS.
}
For the details on these errors, see \link[greybox]{Errors}.
}
\description{
Function calculates several error measures using the provided
forecasts and the data for the holdout sample.
}
\examples{


y <- rnorm(100,10,2)
ourForecast <- rep(mean(y[1:90]),10)

measures(y[91:100],ourForecast,y[1:90],digits=5)

}
\references{
\itemize{
\item Svetunkov, I. (2017). Naughty APEs and the quest for the holy grail.
\url{https://forecasting.svetunkov.ru/en/2017/07/29/naughty-apes-and-the-quest-for-the-holy-grail/}
\item Fildes R. (1992). The evaluation of
extrapolative forecasting methods. International Journal of Forecasting, 8,
pp.81-98.
\item Hyndman R.J., Koehler A.B. (2006). Another look at measures of
forecast accuracy. International Journal of Forecasting, 22, pp.679-688.
\item Petropoulos F., Kourentzes N. (2015). Forecast combinations for
intermittent demand. Journal of the Operational Research Society, 66,
pp.914-924.
\item Wallstrom P., Segerstedt A. (2010). Evaluation of forecasting error
measurements and techniques for intermittent demand. International Journal
of Production Economics, 128, pp.625-636.
\item Davydenko, A., Fildes, R. (2013). Measuring Forecasting Accuracy:
The Case Of Judgmental Adjustments To Sku-Level Demand Forecasts.
International Journal of Forecasting, 29(3), 510-522.
\url{https://doi.org/10.1016/j.ijforecast.2012.09.002}
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
