% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiweek.R
\name{epiweek}
\alias{epiweek}
\title{Constructor for epiweek objects}
\usage{
epiweek(year = integer(), week = integer())
}
\arguments{
\item{year}{\verb{[integer]}

Vector representing the year associated with \code{week}.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{week}{\verb{[integer]}

Vector representing the week associated with `year.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}
}
\value{
A \verb{<grates_epiweek>} object.
}
\description{
\code{epiweek()} is a constructor for \verb{<grates_epiweek>} objects.
}
\details{
Epiweeks are defined to start on a Sunday and \verb{<grates_epiweek>} objects are
stored as the number of weeks (starting at 0) from the first Sunday after the
Unix Epoch (1970-01-01). That is, the number of seven day periods from
1970-01-04.

Internally they have the same representation as a \verb{<grates_yearweek_sunday>}
object so are akin to an alias but with a marginally more efficient
implementation.
}
\examples{
epiweek(year = 2000L, week = 3L)

}
\seealso{
\code{as_epiweek()} and \code{new_epiweek()}.
}
