% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_packages.R
\name{scan_packages}
\alias{scan_packages}
\title{Scan a project or folder for packages used}
\usage{
scan_packages(
  pkgs = "All",
  omit = c("grateful"),
  cite.tidyverse = TRUE,
  dependencies = FALSE,
  ...
)
}
\arguments{
\item{pkgs}{Character. Either "All" to include all packages used in scripts
within the project/folder (the default), or "Session" to include only packages
used in the current session.
Alternatively, \code{pkgs} can also be a character vector of package names to
get citations for. To cite R as well as the given packages,
include "base" in \code{pkgs} (see examples).}

\item{omit}{Character vector of package names to be omitted from the citation
report. \code{grateful} is omitted by default. Use \code{omit = NULL} to include all
packages.}

\item{cite.tidyverse}{Logical. If \code{TRUE}, all tidyverse packages
(dplyr, ggplot2, etc) will be collapsed into a single citation
of the 'tidyverse', as recommended by the tidyverse team.}

\item{dependencies}{Logical. Include the dependencies of your used packages?
If \code{TRUE}, will include all the packages that your used packages depend on.}

\item{...}{Other parameters passed to \code{\link[renv:dependencies]{renv::dependencies()}}.}
}
\value{
a data.frame with package names and versions
}
\description{
Scan a project or folder for packages used
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
scan_packages()
scan_packages(pkgs = "Session")
scan_packages(pkgs = c("renv", "remotes", "knitr"))
\dontshow{\}) # examplesIf}
}
