% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_plan.R
\name{graph_plan}
\alias{graph_plan}
\title{Create a graph with a minimum planar graph topology}
\usage{
graph_plan(crds, ID = NULL, x = NULL, y = NULL, weight = TRUE)
}
\arguments{
\item{crds}{A \code{data.frame} with the spatial
coordinates of the point set (the graph nodes). It must have three columns:
\itemize{
\item{ID: A character string indicating the name of the points(graph nodes).}
\item{x: A numeric or integer indicating the longitude of the graph nodes.}
\item{y: A numeric or integer indicating the latitude of the graph nodes.}
}}

\item{ID}{A character string indicating the name of the column
of \code{crds} with the point IDs}

\item{x}{A character string indicating the name of the column
of \code{crds} with the point longitude}

\item{y}{A character string indicating the name of the column
of \code{crds} with the point latitude}

\item{weight}{A character string indicating whether the links of
the graph are weighted by Euclidean distances (TRUE)(default) or not (FALSE).
When the graph links do not have weights in Euclidean distances, each link
is given a weight of 1.}
}
\value{
A planar graph of class \code{igraph}
}
\description{
The function constructs a graph with a minimum planar
graph topology
}
\details{
A delaunay triangulation is performed in order to get the
planar graph.
}
\examples{
data(pts_pop_ex)
g_plan <- graph_plan(crds = pts_pop_ex,
             ID = "ID",
             x = "x",
             y = "y")
}
\author{
P. Savary
}
