% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{var_range}
\alias{var_range}
\alias{var_range.winmove}
\alias{var_range.numeric}
\title{Size of range of values}
\usage{
var_range(x, ...)

\method{var_range}{winmove}(x, d, type, na.rm = TRUE, ...)

\method{var_range}{numeric}(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{RasterLayer. The data over which to calculate the range size}

\item{...}{further arguments passed to or from other methods}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the
CRS). If \code{type=rectangle} the dimension of the rectangle (one or two numbers)}

\item{type}{character. The shape of the moving window}

\item{na.rm}{logical. indicates whether \code{NA} values should be stripped before the
computation proceeds. \code{na.rm = TRUE} is the default}
}
\value{
If \code{class(x) == "winmove"}, a smoothed raster with the size of the range of values calculated within the specified
  moving window
  
  If \code{class(x) == "numeric"}, a single value representing the size of the range of values in \code{x}
}
\description{
Calculates the difference between the maximum and minimum value
}
\examples{

# load required data
data(cat_ls)
data(cont_ls)

# convert data to object of class winmove
cat_ls <- new("winmove", cat_ls)

# aggregate using a rectangular window with dimensions c(2,3)
d <- range(cont_ls, d = c(2,3), type = "rectangle")

# convert data to object of class numeric
cont_ls <- raster::values(cont_ls)
d <- range(cont_ls)

}
\keyword{focal}
\keyword{range}
\keyword{spatial}
