% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{diversity-metrics}
\alias{diversity-metrics}
\alias{shdi}
\alias{shdi.winmove}
\alias{shdi.numeric}
\alias{shei}
\alias{shei.winmove}
\alias{shei.numeric}
\title{Diversity metrics}
\usage{
\method{shdi}{winmove}(x, lc_class, d, type, ...)

\method{shdi}{numeric}(x, lc_class, ...)

\method{shei}{winmove}(x, lc_class, d, type, ...)

\method{shei}{numeric}(x, lc_class, ...)
}
\arguments{
\item{x}{numeric, winmove. The data over which to calculate the diversity metrics}

\item{lc_class}{numeric. The class values to include in the diversity metric
calculation}

\item{d}{numeric. If \code{type=circle}, the radius of the circle (in units of the
CRS). If \code{type=rectangle} the dimension of the rectangle (one or two numbers)}

\item{type}{character. The shape of the moving window}

\item{...}{further arguments passed to or from other methods}
}
\value{
If \code{class(x) == "winmove"}, a smoothed raster with the diversity
  metric calculated within the specified moving window

  If \code{class(x) == "numeric"}, a single value representing the diversity metric in
  \code{x}
}
\description{
A range of functions to calculate well known landcover diversity metrics
}
\details{
Currently provided diversity metrics are Shannon diversity and Shannon
  evenness. Open a new issue (https://github.com/laurajanegraham/grainchanger/issues)
  to request additional diversity metrics.
}
\examples{
# load required data
data(cat_ls)

# convert data to object of class winmove
cat_ls <- new("winmove", cat_ls)

# calculate Shannon diversity in a rectangular window of dimension 5
d <- shdi(cat_ls, d = 5, type = "rectangle", lc_class = 1:4)

# convert data to object of class numeric
cat_ls <- raster::values(cat_ls)

# calculate Shannon evenness
d <- shei(cat_ls, lc_class = 1:4)
}
\references{
McGarigal, K. and Marks, B.J., 1995. FRAGSTATS: spatial pattern analysis
  program for quantifying landscape structure. \emph{Gen. Tech. Rep. PNW-GTR-351. Portland,
  OR: US Department of Agriculture, Forest Service, Pacific Northwest Research Station.
  122 p, 351.}
}
