% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-vclMatrix.R, R/methods.R
\name{diag,vclMatrix-method}
\alias{diag,vclMatrix-method}
\alias{diag,vclMatrix}
\alias{diag<-,vclMatrix,vclVector-method}
\alias{diag<-,vclMatrix,vclVector}
\alias{diag,gpuMatrix-method}
\alias{diag,gpuMatrix}
\alias{diag<-,gpuMatrix,gpuVector-method}
\alias{diag<-,gpuMatrix,gpuVector}
\title{gpuR Matrix Diagonals}
\usage{
\S4method{diag}{vclMatrix}(x)

\S4method{diag}{vclMatrix,vclVector}(x) <- value

\S4method{diag}{gpuMatrix}(x)

\S4method{diag}{gpuMatrix,gpuVector}(x) <- value
}
\arguments{
\item{x}{A gpuR matrix object}

\item{value}{A vector object (gpuR)}
}
\value{
A \code{gpuRvector} object of the matrix diagonal of \code{x}.  The 
replacement form returns nothing as it replaces the diagonal of \code{x}.
}
\description{
Extract or replace the diagonal of a matrix
}
\note{
If an identity matrix is desired, please see \link{identity_matrix}.
}
\seealso{
\link{identity_matrix}
}
\author{
Charles Determan Jr.
}
