% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map.R
\name{google_map}
\alias{google_map}
\alias{googleway}
\title{Google map}
\usage{
google_map(key, data = NULL, location = NULL, zoom = NULL, width = NULL,
  height = NULL, padding = 0, styles = NULL, search_box = FALSE)
}
\arguments{
\item{key}{A valid Google Maps API key. see Details}

\item{data}{data to be used on the map. This will likely contain two columns for latitude and longitude, and / or encoded polylines for plotting polylines and polygons}

\item{location}{\code{numeric} vector of latitude/longitude (in that order) coordinates for the initial starting position of the map. The map will automatically set the location and zoom if markers are supplied through \link{add_markers}. If null, the map will default to Melbourne, Australia.}

\item{zoom}{\code{integer} representing the zoom level of the map (0 is fully zoomed out)}

\item{width}{the width of the map}

\item{height}{the height of the map}

\item{padding}{the padding of the map}

\item{styles}{JSON string representation of a valid Google Maps styles Array. See the Google documentation for details \url{https://developers.google.com/maps/documentation/javascript/styling}}

\item{search_box}{\code{boolean} indicating if a search box should be placed on the map}
}
\description{
Generates a google map object
}
\details{
The data argument is only needed if you call other functions to add layers to the map, such as \code{add_markers()} or \code{add_polylines}. However, the data argument can also be passed into those functions as well.

In order to use Google Maps you need a valid Google Maps Web JavaScript API key. See the Google Maps API documentation \url{https://developers.google.com/maps/}
}
\examples{
\dontrun{

library(magrittr)  ## for the \%>\% pipes

map_key <- "your_api_key"
df <- structure(list(lat = c(-37.8201904296875, -37.8197288513184,
-37.8191299438477, -37.8187675476074, -37.8186187744141, -37.8181076049805
), lon = c(144.968612670898, 144.968414306641, 144.968139648438,
144.967971801758, 144.967864990234, 144.967636108398), weight = c(31.5698964400217,
97.1629025738221, 58.9051092562731, 76.3215389118996, 37.8982300488278,
77.1501972114202), opacity = c(0.2, 0.2, 0.2, 0.2, 0.2, 0.2)), .Names = c("lat",
"lon", "weight", "opacity"), row.names = 379:384, class = "data.frame")

library(magrittr)
google_map(key = map_key, data = df_line) \%>\%
 add_markers() \%>\%
 add_heatmap() \%>\%
 add_traffic()

## style map using 'cobalt simplified' style
style <- '[{"featureType":"all","elementType":"all","stylers":[{"invert_lightness":true},
{"saturation":10},{"lightness":30},{"gamma":0.5},{"hue":"#435158"}]},
{"featureType":"road.arterial","elementType":"all","stylers":[{"visibility":"simplified"}]},
{"featureType":"transit.station","elementType":"labels.text","stylers":[{"visibility":"off"}]}]'
google_map(key = map_key, styles = style)

}


}

