% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildstep_templates_git.R
\name{cr_buildstep_gitsetup}
\alias{cr_buildstep_gitsetup}
\alias{cr_buildstep_git}
\alias{git_volume}
\title{Create a build step for authenticating with Git}
\usage{
cr_buildstep_gitsetup(secret, post_setup = NULL)

cr_buildstep_git(
  git_args = c("clone", "git@github.com:[GIT-USERNAME]/[REPOSITORY]", "."),
  ...
)

git_volume()
}
\arguments{
\item{secret}{The name of the secret on Google Secret Manager for the git ssh private key}

\item{post_setup}{Steps that occur after git setup}

\item{git_args}{The arguments to send to git}

\item{...}{Further arguments passed in to \link{cr_buildstep}}
}
\description{
This creates steps to configure git to use an ssh created key.

This creates steps to use git with an ssh created key.
}
\details{
The ssh private key should be uploaded to Google Secret Manager first

\code{cr_buildstep} must come after \code{cr_buildstep_gitsetup}

Use \code{git_volume} to add the git credentials folder to other buildsteps
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")

# assumes you have previously saved git ssh key called "github-ssh"
cr_build_yaml(
  steps = c(
    cr_buildstep_gitsetup("github-ssh"),
    cr_buildstep_git(c(
      "clone",
      "git@github.com:github_name/repo_name"
    ))
  )
)
}
\seealso{
\href{https://cloud.google.com/build/docs/access-github-from-build}{Accessing private GitHub repositories using Cloud Build (google article)}

Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_packagetests}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep_targets}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
