% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudrun.R
\name{cr_run}
\alias{cr_run}
\title{Create a CloudRun service.}
\usage{
cr_run(
  image,
  name = basename(image),
  allowUnauthenticated = TRUE,
  concurrency = 1,
  timeout = 600L,
  region = cr_region_get(),
  projectId = cr_project_get(),
  launch_browser = interactive()
)
}
\arguments{
\item{image}{The name of the image to create or use in deployment - \code{gcr.io}}

\item{name}{Name for deployment on Cloud Run}

\item{allowUnauthenticated}{TRUE if can be reached from public HTTP address.}

\item{concurrency}{How many connections each image can serve. Can be up to 80.}

\item{timeout}{Amount of time that this build should be allowed to run, to second}

\item{region}{The endpoint region for deployment}

\item{projectId}{The GCP project from which the services should be listed}

\item{launch_browser}{Whether to launch the logs URL in a browser once deployed}
}
\description{
Deploys an existing gcr.io image.
}
\details{
Uses Cloud Build to deploy an image to Cloud Run
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_run("gcr.io/my-project/my-image")
}
}
\seealso{
\href{https://cloud.google.com/run/}{Google Documentation for Cloud Run}

Use \link{cr_deploy_docker} or similar to create image, \link{cr_deploy_run} to automate building and deploying, \link{cr_deploy_plumber} to deploy plumber APIs.

\href{https://cloud.google.com/cloud-build/docs/deploying-builds/deploy-cloud-run}{Deploying Cloud Run using Cloud Build}

Other Cloud Run functions: 
\code{\link{cr_plumber_pubsub}()},
\code{\link{cr_run_get}()},
\code{\link{cr_run_list}()}
}
\concept{Cloud Run functions}
