% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConstValue.R
\name{plotConstValue}
\alias{plotConstValue}
\title{Plot Fit Equivalent and Constant Value}
\usage{
plotConstValue(measured_value, doflist = c(2:30), pct = 0.95, order = 4,
  ndecimals = 2, fitmetric = R2, ...)
}
\arguments{
\item{measured_value}{a real number, the actual measured value}

\item{doflist}{a vector of integers for the degrees of freedom}

\item{pct}{a real number between 0 and 1, acceptable minimum level of noise}

\item{order}{a real number}

\item{ndecimals}{an integer}

\item{fitmetric}{a character string naming a standard fit metric (R2, rmse, or user)}

\item{...}{any argument that functions within this routine might use}
}
\value{
ggplot object
}
\description{
Plots the Fit Equivalent with Constant Measured Value
}
\examples{
plotConstValue(0.8, doflist=c(2:10),order=3)
plotConstValue(0.1, doflist=c(2:10),order=3,fitmetric=rmse)

}

