% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{gmfd_test}
\alias{gmfd_test}
\title{Two-sample hypotesis tests}
\usage{
gmfd_test(FD1, FD2, conf.level = 0.95, stat_test, p = NULL,
  k_trunc = NULL)
}
\arguments{
\item{FD1}{a functional data object of type \code{funData} of the first sample.}

\item{FD2}{a functional data object of type \code{funData} of the second sample.}

\item{conf.level}{confidence level of the test.}

\item{stat_test}{the chosen test statistic to be used: \code{"L2"} for the classical L2-distance, \code{"L2_trunc"} for the truncated L2-distance, \code{"trunc"} for the truncated Mahalanobis semi-distance, \code{"mahalanobis"} for the generalized Mahalanobis distance}

\item{p}{a vector of positive numeric value containing the parameters of the regularizing function for the generalized Mahalanobis distance.}

\item{k_trunc}{a positive numeric value representing the number of components at which the truncated mahalanobis distance must be truncated}
}
\value{
The function returns a list with the following components:

\code{statistic} the value of the test statistic.

\code{quantile} the value of the quantile.

\code{p.value} the p-value for the test.
}
\description{
Performs a  two sample hypotesis tests on two samples of functional data.
}
\examples{
# Define parameters
n <- 50
P <- 100
K <- 150

# Grid of the functional dataset
t <- seq( 0, 1, length.out = P )

# Define the means and the parameters to use in the simulation
m1 <- t^2 * ( 1 - t )

rho <- rep( 0, K )
theta <- matrix( 0, K, P )
for ( k in 1:K) {
  rho[k] <- 1 / ( k + 1 )^2
  if ( k\%\%2 == 0 )
    theta[k, ] <- sqrt( 2 ) * sin( k * pi * t )
  else if ( k\%\%2 != 0 && k != 1 )
    theta[k, ] <- sqrt( 2 ) * cos( ( k - 1 ) * pi * t )
  else
    theta[k, ] <- rep( 1, P )
}

s <- 0
for ( k in 4:K ) {
 s <- s + sqrt( rho[k] ) * theta[k,]
}

m2 <- m1 + 0.1 * s

# Simulate the functional data
x1 <- gmfd_simulate( n, m1, rho = rho, theta = theta )
x2 <- gmfd_simulate( n, m2, rho = rho, theta = theta )
FD1 <- funData( t, x1 )
FD2 <- funData( t, x2 )
output <- gmfd_test( FD1, FD2, 0.95, "mahalanobis", p = 10^5 )
}
\references{
Ghiglietti A., Ieva F., Paganoni A. M. (2017). Statistical inference for stochastic processes:
Two-sample hypothesis tests, \emph{Journal of Statistical Planning and Inference}, 180:49-68.

Ghiglietti A., Paganoni A. M. (2017). Exact tests for the means of gaussian stochastic processes.
\emph{Statics & Probability Letters}, 131:102--107.
}
\seealso{
\code{\link{funDist}}
}
\keyword{Inference}
