% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempo.R
\name{Tempo}
\alias{Tempo}
\title{Create \code{Tempo} Object}
\usage{
Tempo(tempo, unit = NULL, bar = NULL, offset = NULL)
}
\arguments{
\item{tempo}{A number between 5 and 999 which indicates how many quarter
notes per minute the tempo is.}

\item{unit}{Optional. A duration notation, its abbreviation, or duration
value corresponding to "whole", "half", "quarter", "eighth", "16th", with
or without a dot. The default \code{unit} is "quarter".}

\item{bar}{Optional. A positive integer which indicates the number of
the measure at which to add the \code{Tempo} object. By default, a \code{Tempo}
object will be added at the first measure.}

\item{offset}{Optional. A duration value, sum of duration values or 0,
which indicates the position in a measure, at which to add the \code{Tempo}
object. The default value is 0.}
}
\value{
A list with class \code{Tempo}.
}
\description{
Create a \code{Tempo} object.

\code{Tempo} objects represent tempo marks.
}
\examples{
# create a Tempo object
Tempo(200)

# set unit in a Tempo object
Tempo(120, unit = "half.")

# add Tempo objects to a Music object
Music() + Tempo(200) + Tempo(100, bar = 10, offset = 1)
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding \code{Tempo} objects to a \code{Music} object.

\code{vignette("gm", package = "gm")} for details about duration notations
and duration values.
}
